<?php
/**
 * Setup Script
 * 
 * Jalankan file ini SATU KALI untuk membuat folder-folder yang diperlukan
 * 
 * Usage: php setup.php
 */

$folders = [
    __DIR__ . '/storage',
    __DIR__ . '/storage/uploads',
    __DIR__ . '/storage/uploads/originals',
    __DIR__ . '/storage/uploads/optimized',
    __DIR__ . '/storage/thumbs',
    __DIR__ . '/public/assets',
];

echo "=== PNG Gallery Setup ===\n\n";

foreach ($folders as $folder) {
    if (!file_exists($folder)) {
        if (mkdir($folder, 0755, true)) {
            echo "✅ Created: $folder\n";
        } else {
            echo "❌ Failed to create: $folder\n";
        }
    } else {
        echo "⏭️  Already exists: $folder\n";
    }
}

// Create .gitkeep files
$gitkeepFolders = [
    __DIR__ . '/storage/uploads/originals',
    __DIR__ . '/storage/uploads/optimized',
    __DIR__ . '/storage/thumbs',
];

foreach ($gitkeepFolders as $folder) {
    $gitkeep = $folder . '/.gitkeep';
    if (!file_exists($gitkeep)) {
        file_put_contents($gitkeep, '');
        echo "✅ Created .gitkeep in: $folder\n";
    }
}

echo "\n=== Checking PHP Extensions ===\n\n";

// Check required extensions
$requiredExtensions = ['gd', 'fileinfo', 'session'];

foreach ($requiredExtensions as $ext) {
    if (extension_loaded($ext)) {
        echo "✅ $ext: installed\n";
    } else {
        echo "❌ $ext: NOT installed (REQUIRED!)\n";
    }
}

echo "\n=== Checking Permissions ===\n\n";

foreach ($folders as $folder) {
    if (is_writable($folder)) {
        echo "✅ $folder: writable\n";
    } else {
        echo "⚠️  $folder: NOT writable (may cause issues)\n";
    }
}

echo "\n=== Setup Complete! ===\n\n";
echo "Next steps:\n";
echo "1. Edit includes/config.php and change the default password\n";
echo "2. Point your web server to the /public folder\n";
echo "3. Access login.php to start using the gallery\n";
echo "4. Default credentials: admin / password\n\n";
echo "⚠️  IMPORTANT: Change the default password immediately!\n";
echo "Generate new hash with: php -r \"echo password_hash('your_password', PASSWORD_DEFAULT);\";\n\n";
