<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/csrf.php';
require_once __DIR__ . '/../../includes/PngHandler.php';

// Require login
Auth::requireLogin();

// Get filename
$file = $_GET['file'] ?? '';
$confirm = isset($_GET['confirm']);

// Validate filename
$file = basename($file);
if (empty($file) || !preg_match('/^[a-zA-Z0-9_-]+\.png$/', $file)) {
    die('Invalid filename');
}

// Check if file exists
if (!file_exists(ORIGINALS_PATH . '/' . $file)) {
    die('File not found');
}

// If confirmed from SweetAlert, delete immediately
if ($confirm) {
    $handler = new PngHandler();
    if ($handler->delete($file)) {
        // Redirect with success
        header('Location: ' . BASE_URL . '/index.php?deleted=1');
        exit;
    } else {
        // Redirect with error
        header('Location: ' . BASE_URL . '/index.php?delete_error=1');
        exit;
    }
}

// If no confirm, show confirmation page (fallback for non-JS users)
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verify CSRF
    CSRF::verifyOrDie();
    
    // Delete file
    $handler = new PngHandler();
    if ($handler->delete($file)) {
        $success = true;
    } else {
        $error = 'Gagal menghapus file';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Image - Gallery</title>
    
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .delete-card {
            background: white;
            border-radius: 12px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            text-align: center;
        }
        .icon {
            font-size: 64px;
            margin-bottom: 20px;
        }
        h2 {
            margin-bottom: 10px;
            color: #333;
        }
        p {
            color: #666;
            margin-bottom: 20px;
        }
        .filename {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            word-break: break-all;
            font-weight: 600;
        }
        .preview {
            width: 200px;
            height: 200px;
            margin: 20px auto;
            background: 
                linear-gradient(45deg, #f0f0f0 25%, transparent 25%),
                linear-gradient(-45deg, #f0f0f0 25%, transparent 25%),
                linear-gradient(45deg, transparent 75%, #f0f0f0 75%),
                linear-gradient(-45deg, transparent 75%, #f0f0f0 75%);
            background-size: 20px 20px;
            background-position: 0 0, 0 10px, 10px -10px, -10px 0px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .preview img {
            max-width: 100%;
            max-height: 100%;
        }
        .actions {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }
        .btn {
            flex: 1;
            padding: 12px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            cursor: pointer;
            border: none;
            font-size: 14px;
            transition: all 0.3s;
        }
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .btn-secondary {
            background: #f0f0f0;
            color: #666;
        }
        .btn-secondary:hover {
            background: #e0e0e0;
        }
        .success {
            color: #28a745;
        }
        .error {
            color: #dc3545;
            margin-top: 10px;
        }
        .btn-primary {
            background: #667eea;
            color: white;
        }
        .btn-primary:hover {
            background: #5568d3;
        }
    </style>
</head>
<body>
    <div class="delete-card">
        <?php if ($success): ?>
            <script>
                Swal.fire({
                    icon: 'success',
                    title: 'Deleted!',
                    text: 'File has been deleted successfully',
                    confirmButtonColor: '#667eea'
                }).then(() => {
                    window.location.href = '<?php echo BASE_URL; ?>/index.php';
                });
            </script>
        <?php else: ?>
            <div class="icon">⚠️</div>
            <h2>Hapus File Ini?</h2>
            <p>File akan dihapus secara permanen (original, optimized, dan thumbnail)</p>

            <div class="filename">
                📄 <?php echo htmlspecialchars($file); ?>
            </div>

            <div class="preview">
                <img src="<?php echo BASE_URL; ?>/image.php?type=thumb&file=<?php echo urlencode($file); ?>" alt="Preview">
            </div>

            <?php if ($error): ?>
                <div class="error">❌ <?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>

            <form method="POST" style="margin: 0;">
                <?php echo CSRF::field(); ?>
                <div class="actions">
                    <a href="<?php echo BASE_URL; ?>/index.php" class="btn btn-secondary">Cancel</a>
                    <button type="submit" class="btn btn-danger">Delete Permanently</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
