<?php
/**
 * Authentication Helper
 * Mengelola login/logout untuk single user
 */

class Auth
{
    /**
     * Check if user is logged in
     */
    public static function check()
    {
        return isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;
    }

    /**
     * Login user
     */
    public static function login($username, $password)
    {
        if ($username === ADMIN_USERNAME && password_verify($password, ADMIN_PASSWORD_HASH)) {
            $_SESSION['logged_in'] = true;
            $_SESSION['username'] = $username;
            $_SESSION['login_time'] = time();
            
            // Regenerate session ID untuk security
            session_regenerate_id(true);
            
            return true;
        }
        return false;
    }

    /**
     * Logout user
     */
    public static function logout()
    {
        $_SESSION = array();
        
        if (isset($_COOKIE[session_name()])) {
            setcookie(session_name(), '', time() - 3600, '/');
        }
        
        session_destroy();
    }

    /**
     * Require login (redirect jika belum login)
     */
    public static function requireLogin()
    {
        if (!self::check()) {
            header('Location: ' . BASE_URL . '/login.php');
            exit;
        }
    }

    /**
     * Redirect if already logged in
     */
    public static function redirectIfLoggedIn()
    {
        if (self::check()) {
            header('Location: ' . BASE_URL . '/index.php');
            exit;
        }
    }

    /**
     * Get username
     */
    public static function username()
    {
        return $_SESSION['username'] ?? null;
    }
}
