<?php
/**
 * Demo Script: Generate Sample Transparent PNG
 * 
 * Script ini membuat sample PNG transparan untuk testing
 * Jalankan: php demo_generate_png.php
 */

// Create 400x400 image
$width = 400;
$height = 400;
$img = imagecreatetruecolor($width, $height);

// === CRITICAL: Enable alpha channel ===
imagealphablending($img, false);
imagesavealpha($img, true);

// Create transparent background
$transparent = imagecolorallocatealpha($img, 0, 0, 0, 127);
imagefill($img, 0, 0, $transparent);

// Draw some shapes with different alpha levels
// Semi-transparent red circle
$red = imagecolorallocatealpha($img, 255, 0, 0, 50); // alpha 50 = semi-transparent
imagefilledellipse($img, 150, 150, 200, 200, $red);

// More transparent blue circle
$blue = imagecolorallocatealpha($img, 0, 0, 255, 100); // alpha 100 = more transparent
imagefilledellipse($img, 250, 150, 200, 200, $blue);

// Fully opaque green circle
$green = imagecolorallocatealpha($img, 0, 255, 0, 0); // alpha 0 = fully opaque
imagefilledellipse($img, 200, 250, 200, 200, $green);

// Add text
$white = imagecolorallocatealpha($img, 255, 255, 255, 0);
imagestring($img, 5, 150, 190, "Transparent", $white);
imagestring($img, 5, 170, 210, "PNG Test", $white);

// Save PNG
$outputPath = __DIR__ . '/sample_transparent.png';
imagepng($img, $outputPath, 9);
imagedestroy($img);

echo "✅ Sample PNG created: $outputPath\n";
echo "   File size: " . number_format(filesize($outputPath) / 1024, 2) . " KB\n";
echo "   This PNG has transparent background and multiple alpha levels\n";
echo "   Upload this file to test transparency preservation!\n";
