# Changelog

All notable changes to PNG Gallery Private will be documented in this file.

## [2.0.0] - 2024-11-22

### 🎉 Major Feature Update

#### New Features
- ✅ **File Rename** - Rename PNG files without re-uploading
  - AJAX-based rename (no page reload)
  - Real-time validation
  - Duplicate name detection
  - Automatic rollback on failure
  - Renames all versions (original, optimized, thumbnail)

- ✅ **Pagination System** - Better performance for large galleries
  - 10 images per page (configurable)
  - First/Last page navigation
  - Previous/Next buttons
  - Current page indicator
  - Page number display

- ✅ **SweetAlert2 Integration** - Beautiful notifications
  - Upload success/error notifications
  - Delete confirmation modal
  - Rename dialog with validation
  - Loading indicators
  - Professional styling

- ✅ **Dark Mode** - Eye-friendly theme
  - Toggle between light/dark themes
  - Saved in localStorage
  - Persistent across sessions
  - CSS variables for easy customization
  - Smooth transitions

#### Technical Improvements
- Added `rename()` method to PngHandler class
- Added `getPaginatedImages()` method for efficient pagination
- Implemented CSS variable system for theming
- AJAX endpoints for rename functionality
- Better error handling with detailed messages

#### UI/UX Enhancements
- Modern notification system
- Improved button layout
- Better spacing and alignment
- Hover effects and animations
- Responsive design improvements

#### Files Modified
- `includes/PngHandler.php` - Added rename() and getPaginatedImages() methods
- `public/index.php` - Complete redesign with new features
- `public/admin/upload.php` - SweetAlert integration
- `public/admin/delete.php` - SweetAlert confirmation
- `public/admin/rename.php` - NEW FILE for rename handling

#### Breaking Changes
- None! Fully backward compatible with v1.0.0

#### Migration Notes
- Existing images work without changes
- No database migration needed
- SweetAlert requires internet (CDN) or local installation
- Dark mode preference stored in browser localStorage

---

## [1.0.0] - 2024-11-22

### 🎉 Initial Release

#### Core Features
- ✅ **PNG Transparency Preservation** - Alpha channel tetap utuh di seluruh pipeline
- ✅ **Secure Upload System** - CSRF protected dengan file validation
- ✅ **Private File Storage** - Storage folder tidak bisa diakses langsung
- ✅ **Session-based Authentication** - Single user login dengan password hashing
- ✅ **Image Optimization** - Kompresi PNG dengan imagepng() level 0-9
- ✅ **Thumbnail Generation** - Thumbnail transparan dengan checkerboard background
- ✅ **Clean Gallery UI** - Grid layout dengan lightbox preview
- ✅ **Secure Image Serving** - Semua akses via image.php dengan session check

#### Security Features
- Password hashing dengan bcrypt (password_hash)
- CSRF token protection (bin2hex + random_bytes)
- Session regeneration on login
- File type validation (MIME + extension)
- Filename sanitization (basename + regex)
- httponly session cookie
- .htaccess protection untuk storage folder

#### Technical Implementation
- PHP 7.4+ dengan GD library
- No database (file-based)
- Single user system
- Compression level: 7 (configurable 0-9)
- Thumbnail size: 200px (configurable)
- Max file size: 10MB (configurable)

#### Files Included
- `public/index.php` - Gallery view
- `public/login.php` - Login page
- `public/logout.php` - Logout handler
- `public/image.php` - Secure image server
- `public/admin/upload.php` - Upload handler
- `public/admin/delete.php` - Delete handler
- `includes/config.php` - Configuration
- `includes/auth.php` - Authentication helper
- `includes/csrf.php` - CSRF protection
- `includes/PngHandler.php` - PNG processor (critical)
- `setup.php` - Setup script
- `demo_generate_png.php` - Sample PNG generator

#### Documentation
- `README.md` - Main documentation
- `QUICKSTART.md` - Quick start guide
- `INSTALL.md` - Installation guide (Apache/Nginx)
- `TESTING.md` - Testing guide untuk verify transparency
- `SUMMARY.md` - Technical summary & architecture
- `CHANGELOG.md` - This file
- `INDEX.html` - HTML documentation index

#### Critical Code Patterns

**PNG Transparency Preservation:**
```php
$img = imagecreatefrompng($source);
imagealphablending($img, false);  // WAJIB
imagesavealpha($img, true);       // WAJIB
imagepng($img, $dest, PNG_COMPRESSION);
imagedestroy($img);
```

**Thumbnail Canvas Setup:**
```php
$thumb = imagecreatetruecolor($w, $h);
imagealphablending($thumb, false);
$transparent = imagecolorallocatealpha($thumb, 0, 0, 0, 127);
imagefill($thumb, 0, 0, $transparent);
imagesavealpha($thumb, true);
```

#### Known Limitations
- Single user only (no multi-user support)
- No folder organization (flat structure)
- No bulk upload
- No image editing (crop, rotate)
- No search functionality
- No API endpoints

### Future Enhancements (Planned)

#### v1.1.0 (Future)
- [ ] Bulk upload support
- [ ] Folder organization
- [ ] Basic search functionality
- [ ] Image metadata display

#### v1.2.0 (Future)
- [ ] Tags/categories
- [ ] Advanced search
- [ ] Download as ZIP
- [ ] Share links (with expiry)

#### v2.0.0 (Future)
- [ ] Multi-user support (optional)
- [ ] API endpoints
- [ ] Image editor (crop, rotate, resize)
- [ ] Progressive Web App (PWA)

---

## Version Format

- **Major.Minor.Patch** (Semantic Versioning)
- Major: Breaking changes
- Minor: New features (backward compatible)
- Patch: Bug fixes

## Categories

- **Added** - New features
- **Changed** - Changes in existing functionality
- **Deprecated** - Soon-to-be removed features
- **Removed** - Removed features
- **Fixed** - Bug fixes
- **Security** - Security fixes

---

**Note:** Transparansi PNG adalah prioritas #1. Semua fitur baru harus mempertahankan alpha channel!
