<?php

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Timezone
date_default_timezone_set('UTC');

// Paths
define('BASE_PATH', dirname(__DIR__));
define('UPLOADS_PATH', BASE_PATH . '/uploads');
define('STORAGE_PATH', BASE_PATH . '/storage');

// Ensure directories exist
if (!is_dir(UPLOADS_PATH)) {
    mkdir(UPLOADS_PATH, 0755, true);
}

if (!is_dir(STORAGE_PATH . '/users')) {
    mkdir(STORAGE_PATH . '/users', 0755, true);
}

if (!is_dir(STORAGE_PATH . '/session')) {
    mkdir(STORAGE_PATH . '/session', 0755, true);
}

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);
