<?php

class Auth {
    public static function isLoggedIn() {
        return isset($_SESSION['user']) && !empty($_SESSION['user']);
    }
    
    public static function requireLogin() {
        if (!self::isLoggedIn()) {
            header('Location: /login');
            exit;
        }
    }
    
    public static function getCurrentUser() {
        return $_SESSION['user'] ?? null;
    }
    
    public static function isAdmin() {
        $user = self::getCurrentUser();
        return $user && ($user['role'] ?? '') === 'admin';
    }
    
    public static function login($user) {
        // Remove password from session
        unset($user['password']);
        $_SESSION['user'] = $user;
        
        // BUG #6 FIX: Log login activity
        self::logLoginActivity($user['id'], $user['username'], 'success');
    }
    
    public static function logout() {
        session_destroy();
        header('Location: /login');
        exit;
    }
    
    // BUG #6 FIX: Login history tracking
    public static function logLoginActivity($userId, $username, $status) {
        $historyFile = STORAGE_PATH . '/session/login_history.json';
        
        $history = [];
        if (file_exists($historyFile)) {
            $json = file_get_contents($historyFile);
            $history = json_decode($json, true) ?: [];
        }
        
        $entry = [
            'user_id' => $userId,
            'username' => $username,
            'timestamp' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown',
            'status' => $status
        ];
        
        $history[] = $entry;
        
        // Keep only last 500 entries
        if (count($history) > 500) {
            $history = array_slice($history, -500);
        }
        
        file_put_contents($historyFile, json_encode($history, JSON_PRETTY_PRINT));
    }
}
