<?php
require_once __DIR__ . "/../includes/UserManager.php";

session_start();
if (!isset($_SESSION['user'])) {
    http_response_code(403);
    exit("Not logged in");
}

$username = $_SESSION['user']['username'];
$user = UserManager::getUser($username);

$avatarPath = __DIR__ . "/../storage/users/" . $username . "/avatar.png";

if (!file_exists($avatarPath)) {
    // fallback avatar
    $avatarPath = __DIR__ . "/../public/assets/img/default-avatar.png";
}

header("Content-Type: image/png");
header("Cache-Control: no-cache, must-revalidate");
readfile($avatarPath);
exit;
