<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';

Auth::requireLogin();

$userId = $_SESSION['user']['id'];
$avatarDir = STORAGE_PATH . '/avatars';
$avatarPath = $avatarDir . "/$userId.png";

if (!file_exists($avatarPath)) {
    // Default avatar SVG
    header("Content-Type: image/svg+xml");
    echo <<<SVG
<svg width="200" height="200" viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
    <defs>
        <linearGradient id="grad" x1="0" x2="1" y1="0" y2="1">
            <stop offset="0%" stop-color="#a78bfa"/>
            <stop offset="100%" stop-color="#6d28d9"/>
        </linearGradient>
    </defs>
    <circle cx="100" cy="100" r="100" fill="url(#grad)"/>
    <circle cx="100" cy="75" r="30" fill="white" opacity="0.9"/>
    <path d="M 60 140 Q 100 110 140 140 L 140 200 L 60 200 Z" 
          fill="white" opacity="0.9"/>
</svg>
SVG;
    exit;
}

// Serve real avatar
header('Content-Type: image/png');
header('Content-Length: ' . filesize($avatarPath));
header('Cache-Control: public, max-age=0'); // always refresh
readfile($avatarPath);
exit;
