<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/csrf.php';
require_once __DIR__ . '/../../includes/PngHandler.php';

// Require login
Auth::requireLogin();

// Handle AJAX request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
    // Verify CSRF
    $token = $_POST[CSRF_TOKEN_NAME] ?? '';
    if (!CSRF::verify($token)) {
        echo json_encode(['success' => false, 'message' => 'CSRF token validation failed']);
        exit;
    }
    
    $oldFilename = $_POST['old_filename'] ?? '';
    $newFilename = $_POST['new_filename'] ?? '';
    
    if (empty($oldFilename) || empty($newFilename)) {
        echo json_encode(['success' => false, 'message' => 'Filename cannot be empty']);
        exit;
    }
    
    $handler = new PngHandler();
    $result = $handler->rename($oldFilename, $newFilename);
    
    if ($result === true) {
        echo json_encode([
            'success' => true, 
            'message' => 'Udah Ganti Nama Filenya Master J!',
            'new_filename' => $newFilename . '.png'
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => $result['error'] ?? 'Gagal Ganti Nama Filenya Master J!'
        ]);
    }
    exit;
}

// Not POST request
http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);
