<?php
/**
 * CSRF Protection Helper
 */

class CSRF
{
    /**
     * Generate CSRF token
     */
    public static function generateToken()
    {
        if (!isset($_SESSION[CSRF_TOKEN_NAME])) {
            $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
        }
        return $_SESSION[CSRF_TOKEN_NAME];
    }

    /**
     * Get CSRF token
     */
    public static function getToken()
    {
        return $_SESSION[CSRF_TOKEN_NAME] ?? '';
    }

    /**
     * Verify CSRF token
     */
    public static function verify($token)
    {
        if (!isset($_SESSION[CSRF_TOKEN_NAME])) {
            return false;
        }
        return hash_equals($_SESSION[CSRF_TOKEN_NAME], $token);
    }

    /**
     * Generate hidden input field
     */
    public static function field()
    {
        $token = self::generateToken();
        return '<input type="hidden" name="' . CSRF_TOKEN_NAME . '" value="' . htmlspecialchars($token) . '">';
    }

    /**
     * Verify request or die
     */
    public static function verifyOrDie()
    {
        $token = $_POST[CSRF_TOKEN_NAME] ?? $_GET[CSRF_TOKEN_NAME] ?? '';
        
        if (!self::verify($token)) {
            http_response_code(403);
            die('CSRF token validation failed');
        }
    }
}
