<?php
/**
 * Konfigurasi Sistem Galeri PNG Private
 */

// Error reporting (matikan di production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set 1 jika menggunakan HTTPS

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Path configuration
define('BASE_PATH', dirname(__DIR__));
define('PUBLIC_PATH', BASE_PATH . '/public');
define('STORAGE_PATH', BASE_PATH . '/storage');
define('UPLOADS_PATH', STORAGE_PATH . '/uploads');
define('ORIGINALS_PATH', UPLOADS_PATH . '/originals');
define('OPTIMIZED_PATH', UPLOADS_PATH . '/optimized');
define('THUMBS_PATH', STORAGE_PATH . '/thumbs');

// URL configuration (sesuaikan dengan domain Anda)
define('BASE_URL', '/public');

// Admin credentials
// GANTI PASSWORD INI! Generate dengan: password_hash('password_anda', PASSWORD_DEFAULT)
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD_HASH', '$2a$12$/ESWotGyQnCOXUUQtLFd1eFPQDlCdAK54mxbG3gxhF1.muZUHZf9W'); // password: password

// PNG Settings
define('PNG_COMPRESSION', 7); // 0-9, semakin tinggi semakin kecil file (tapi lebih lama proses)
define('THUMBNAIL_SIZE', 200); // pixels
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_MIME', 'image/png');

// Session name
define('SESSION_NAME', 'PNG_GALLERY_SESSION');

// CSRF token name
define('CSRF_TOKEN_NAME', 'csrf_token');

/**
 * Autoload classes
 */
spl_autoload_register(function ($class) {
    $file = BASE_PATH . '/includes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

/**
 * Start session
 */
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}
