<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/Auth.php';
require_once __DIR__ . '/../includes/FolderManager.php';
require_once __DIR__ . '/../includes/ImageManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();
$folderManager = new FolderManager();
$imageManager = new ImageManager();

$query = $_GET['q'] ?? '';
$folders = [];
$images = [];

if (!empty($query)) {
    $folders = $folderManager->searchFolders($query, $username, $isAdmin);
    $images = $imageManager->searchImages($query, $username, $isAdmin);
}

$pageTitle = 'Search - Galeriku ProMax';
$pageHeader = 'Search';
include __DIR__ . '/components/header.php';
?>

<div class="card" style="margin-bottom: var(--spacing-xl);">
    <form method="GET" action="" class="flex gap-md">
        <div class="input-group" style="flex: 1;">
            <span class="input-icon"><?php echo UIIcons::search('icon-sm'); ?></span>
            <input 
                type="text" 
                name="q" 
                class="form-input input-with-icon" 
                placeholder="Search folders and images..." 
                value="<?php echo htmlspecialchars($query); ?>"
                autofocus
            >
        </div>
        <button type="submit" class="btn btn-primary">
            <?php echo UIIcons::search(); ?>
            <span>Search</span>
        </button>
    </form>
</div>

<?php if (empty($query)): ?>
    <div class="empty-state">
        <?php echo UIIcons::search('empty-icon'); ?>
        <h3 class="empty-title">Start searching</h3>
        <p class="empty-text">Enter keywords to search for folders and images</p>
    </div>
<?php elseif (empty($folders) && empty($images)): ?>
    <div class="empty-state">
        <?php echo UIIcons::alertCircle('empty-icon'); ?>
        <h3 class="empty-title">No results found</h3>
        <p class="empty-text">Try different keywords or check your spelling</p>
    </div>
<?php else: ?>
    
    <?php if (!empty($folders)): ?>
        <div style="margin-bottom: var(--spacing-2xl);">
            <div class="flex items-center gap-md" style="margin-bottom: var(--spacing-lg);">
                <h2 style="font-size: 1.25rem; font-weight: 700;">Folders</h2>
                <span class="badge badge-primary"><?php echo count($folders); ?> results</span>
            </div>
            
            <div class="grid grid-auto">
                <?php foreach ($folders as $folder): ?>
                    <a href="folder-view.php?id=<?php echo urlencode($folder['id']); ?>" class="card card-hover" style="text-decoration: none; color: inherit;">
                        <div class="flex items-center gap-md" style="margin-bottom: var(--spacing-md);">
                            <div style="width: 48px; height: 48px; border-radius: var(--radius-lg); background: linear-gradient(135deg, rgba(139, 92, 246, 0.15), rgba(236, 72, 153, 0.15)); display: flex; align-items: center; justify-content: center;">
                                <?php echo UIIcons::folder(); ?>
                            </div>
                            <div style="flex: 1; min-width: 0;">
                                <h3 style="font-weight: 600; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?php echo htmlspecialchars($folder['name']); ?></h3>
                                <p style="font-size: 0.875rem; color: var(--text-secondary);"><?php echo $folder['image_count']; ?> images</p>
                            </div>
                            <span class="badge badge-<?php echo $folder['visibility'] === 'private' ? 'danger' : 'success'; ?>">
                                <?php echo $folder['visibility'] === 'private' ? UIIcons::lock('icon-sm') : UIIcons::globe('icon-sm'); ?>
                            </span>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($images)): ?>
        <div>
            <div class="flex items-center gap-md" style="margin-bottom: var(--spacing-lg);">
                <h2 style="font-size: 1.25rem; font-weight: 700;">Images</h2>
                <span class="badge badge-primary"><?php echo count($images); ?> results</span>
            </div>
            
            <div class="gallery-grid">
                <?php foreach ($images as $image): ?>
                    <div class="gallery-item" onclick="openLightbox('<?php echo htmlspecialchars($image['filename']); ?>', '<?php echo htmlspecialchars($image['owner']); ?>')">
                        <div class="gallery-image">
                            <img src="image.php?file=<?php echo urlencode($image['filename']); ?>&username=<?php echo urlencode($image['owner']); ?>" alt="<?php echo htmlspecialchars($image['filename']); ?>" loading="lazy">
                        </div>
                        <div class="gallery-info">
                            <div class="gallery-title"><?php echo htmlspecialchars($image['filename']); ?></div>
                            <div class="gallery-meta">
                                <span class="badge badge-<?php echo $image['visibility'] === 'private' ? 'danger' : 'success'; ?>">
                                    <?php echo $image['visibility'] === 'private' ? UIIcons::lock('icon-sm') : UIIcons::globe('icon-sm'); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
    
<?php endif; ?>

<div id="lightbox" class="lightbox" onclick="closeLightbox()">
    <button class="lightbox-close" onclick="closeLightbox()"><?php echo UIIcons::x(); ?></button>
    <img id="lightbox-img" src="" alt="">
</div>

<style>
.input-group { position: relative; }
.input-icon { position: absolute; left: 0.875rem; top: 50%; transform: translateY(-50%); color: var(--text-tertiary); }
.input-with-icon { padding-left: 2.75rem; }
.gallery-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(240px, 1fr)); gap: var(--spacing-lg); }
.gallery-item { background: var(--bg-card); border: 1px solid var(--border); border-radius: var(--radius-xl); overflow: hidden; cursor: pointer; transition: all var(--transition-base); }
.gallery-item:hover { border-color: var(--primary); transform: translateY(-2px); box-shadow: var(--shadow-lg); }
.gallery-image { width: 100%; height: 200px; background: repeating-conic-gradient(var(--bg-secondary) 0% 25%, var(--bg-tertiary) 0% 50%) 50% / 20px 20px; display: flex; align-items: center; justify-content: center; }
.gallery-image img { max-width: 100%; max-height: 100%; object-fit: contain; }
.gallery-info { padding: var(--spacing-md); }
.gallery-title { font-weight: 600; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; margin-bottom: var(--spacing-sm); }
.gallery-meta { display: flex; align-items: center; justify-content: space-between; }
.lightbox { position: fixed; inset: 0; background: rgba(0, 0, 0, 0.95); display: none; align-items: center; justify-content: center; z-index: 9999; }
.lightbox.active { display: flex; }
.lightbox img { max-width: 90%; max-height: 90%; }
.lightbox-close { position: absolute; top: var(--spacing-xl); right: var(--spacing-xl); width: 48px; height: 48px; background: var(--primary); border: none; border-radius: 50%; color: white; cursor: pointer; display: flex; align-items: center; justify-content: center; }
</style>

<script>
function openLightbox(filename, owner) {
    document.getElementById('lightbox').classList.add('active');
    document.getElementById('lightbox-img').src = 'image.php?file=' + encodeURIComponent(filename) + '&username=' + encodeURIComponent(owner);
}
function closeLightbox() { document.getElementById('lightbox').classList.remove('active'); }
document.addEventListener('keydown', e => { if (e.key === 'Escape') closeLightbox(); });
</script>

<?php include __DIR__ . '/components/footer.php'; ?>
