<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/Auth.php';
require_once __DIR__ . '/../includes/CSRF.php';
require_once __DIR__ . '/../includes/ui-config.php';

// Redirect if already logged in
if (Auth::isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (Auth::login($username, $password)) {
        header('Location: index.php');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Galeriku ProMax</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="assets/js/theme.js"></script>
    <style>
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: var(--spacing-lg);
            background: linear-gradient(135deg, var(--bg-primary) 0%, var(--bg-secondary) 100%);
        }
        
        .login-card {
            width: 100%;
            max-width: 420px;
            background: var(--bg-card);
            border: 1px solid var(--border);
            border-radius: var(--radius-2xl);
            padding: var(--spacing-2xl);
            box-shadow: var(--shadow-xl);
        }
        
        .login-header {
            text-align: center;
            margin-bottom: var(--spacing-xl);
        }
        
        .login-logo {
            font-size: 2rem;
            font-weight: 700;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: var(--spacing-sm);
        }
        
        .login-subtitle {
            color: var(--text-secondary);
            font-size: 0.875rem;
        }
        
        .login-icon-wrapper {
            width: 64px;
            height: 64px;
            margin: 0 auto var(--spacing-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.1) 0%, rgba(236, 72, 153, 0.1) 100%);
        }
        
        .alert-error {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: var(--danger);
            padding: var(--spacing-md);
            border-radius: var(--radius-md);
            margin-bottom: var(--spacing-lg);
            display: flex;
            align-items: center;
            gap: var(--spacing-sm);
        }
        
        .input-group {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            left: 0.875rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-tertiary);
        }
        
        .input-with-icon {
            padding-left: 2.75rem;
        }
        
        .theme-toggle-login {
            position: fixed;
            top: var(--spacing-lg);
            right: var(--spacing-lg);
        }
        
        .login-footer {
            text-align: center;
            margin-top: var(--spacing-xl);
            padding-top: var(--spacing-lg);
            border-top: 1px solid var(--border);
            color: var(--text-secondary);
            font-size: 0.8125rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <!-- Theme Toggle -->
        <button class="theme-toggle theme-toggle-login" data-theme-toggle aria-label="Toggle theme">
            <div class="theme-toggle-slider">
                <span class="theme-icon-sun"><?php echo UIIcons::sun('icon-sm'); ?></span>
                <span class="theme-icon-moon" style="display: none;"><?php echo UIIcons::moon('icon-sm'); ?></span>
            </div>
        </button>
        
        <div class="login-card">
            <div class="login-header">
                <div class="login-icon-wrapper">
                    <?php echo UIIcons::image('icon-xl'); ?>
                </div>
                <h1 class="login-logo">Galeriku ProMax</h1>
                <p class="login-subtitle">Sign in to your account</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert-error">
                    <?php echo UIIcons::alertCircle('icon-sm'); ?>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <?php echo CSRF::field(); ?>
                
                <div class="form-group">
                    <label class="form-label" for="username">Username</label>
                    <div class="input-group">
                        <span class="input-icon"><?php echo UIIcons::users('icon-sm'); ?></span>
                        <input 
                            type="text" 
                            id="username" 
                            name="username" 
                            class="form-input input-with-icon" 
                            placeholder="Enter your username"
                            required 
                            autofocus
                            autocomplete="username"
                        >
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="password">Password</label>
                    <div class="input-group">
                        <span class="input-icon"><?php echo UIIcons::lock('icon-sm'); ?></span>
                        <input 
                            type="password" 
                            id="password" 
                            name="password" 
                            class="form-input input-with-icon" 
                            placeholder="Enter your password"
                            required
                            autocomplete="current-password"
                        >
                    </div>
                    <div class="form-help">Default: admin / password</div>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%; margin-top: var(--spacing-lg);">
                    <?php echo UIIcons::unlock('icon-sm'); ?>
                    <span>Sign In</span>
                </button>
            </form>
            
            <div class="login-footer">
                <p>Galeriku ProMax v3.0 &copy; <?php echo date('Y'); ?></p>
            </div>
        </div>
    </div>
</body>
</html>
