<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/UserManager.php';

Auth::requireAdmin();

$userManager = new UserManager();
$users = $userManager->getAllUsers();

$pageTitle = 'Users - Galeriku ProMax';
$pageHeader = 'User Management';
include __DIR__ . '/../components/header.php';
?>

<div class="card" style="margin-bottom: var(--spacing-xl);">
    <div class="flex items-center justify-between">
        <h2 class="card-title">All Users (<?php echo count($users); ?>)</h2>
        <a href="user-create.php" class="btn btn-primary btn-sm">
            <?php echo UIIcons::plus('icon-sm'); ?>
            <span>Add User</span>
        </a>
    </div>
</div>

<div class="grid grid-auto">
    <?php foreach ($users as $user): ?>
        <div class="card">
            <div class="flex items-center gap-md" style="margin-bottom: var(--spacing-md);">
                <img src="../user-avatar.php?username=<?php echo urlencode($user['username']); ?>" 
                     style="width: 64px; height: 64px; border-radius: 50%; border: 2px solid var(--border);">
                <div style="flex: 1;">
                    <h3 style="font-weight: 600; margin-bottom: var(--spacing-xs);">
                        <?php echo htmlspecialchars($user['username']); ?>
                    </h3>
                    <span class="badge badge-<?php echo $user['role'] === 'admin' ? 'primary' : 'info'; ?>">
                        <?php echo ucfirst($user['role']); ?>
                    </span>
                </div>
            </div>
            
            <div class="user-stats">
                <div class="stat-item">
                    <?php echo UIIcons::image('icon-sm'); ?>
                    <div>
                        <strong><?php echo $user['total_uploads'] ?? 0; ?></strong>
                        <span>Images</span>
                    </div>
                </div>
                <div class="stat-item">
                    <?php echo UIIcons::folder('icon-sm'); ?>
                    <div>
                        <strong><?php echo formatBytes($user['storage_used'] ?? 0); ?></strong>
                        <span>Storage</span>
                    </div>
                </div>
            </div>
            
            <div class="flex gap-sm" style="margin-top: var(--spacing-md); padding-top: var(--spacing-md); border-top: 1px solid var(--border);">
                <a href="user-edit.php?id=<?php echo urlencode($user['username']); ?>" class="btn btn-secondary btn-sm" style="flex: 1;">
                    <?php echo UIIcons::edit('icon-sm'); ?>
                </a>
                <?php if ($user['username'] !== Auth::getUsername()): ?>
                    <a href="user-delete.php?id=<?php echo urlencode($user['username']); ?>" class="btn btn-secondary btn-sm">
                        <?php echo UIIcons::trash('icon-sm'); ?>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<style>
.user-stats { display: flex; gap: var(--spacing-md); padding: var(--spacing-md); background: var(--bg-secondary); border-radius: var(--radius-md); }
.stat-item { display: flex; align-items: center; gap: var(--spacing-sm); flex: 1; }
.stat-item svg { color: var(--primary); }
.stat-item strong { display: block; font-size: 1.125rem; }
.stat-item span { font-size: 0.75rem; color: var(--text-secondary); }
</style>

<?php include __DIR__ . '/../components/footer.php'; ?>
