<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/CSRF.php';
require_once __DIR__ . '/../../includes/PermissionManager.php';
require_once __DIR__ . '/../../includes/UserManager.php';

Auth::requireAdmin();

$permManager = new PermissionManager();
$userManager = new UserManager();

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $action = $_POST['action'] ?? '';
    $targetUser = $_POST['username'] ?? '';
    
    if ($action === 'update_permissions') {
        $permissions = [
            'can_upload' => isset($_POST['can_upload']),
            'can_create_folders' => isset($_POST['can_create_folders']),
            'can_delete' => isset($_POST['can_delete']),
            'can_share' => isset($_POST['can_share']),
            'can_download_original' => isset($_POST['can_download_original']),
            'storage_quota' => intval($_POST['storage_quota'] ?? 1073741824),
            'max_folders' => intval($_POST['max_folders'] ?? 50),
            'max_images_per_folder' => intval($_POST['max_images_per_folder'] ?? 1000)
        ];
        
        if ($permManager->setUserPermissions($targetUser, $permissions)) {
            $success = 'Permissions updated successfully';
        } else {
            $error = 'Failed to update permissions';
        }
    } elseif ($action === 'apply_preset') {
        $preset = $_POST['preset'] ?? '';
        if ($permManager->applyPreset($targetUser, $preset)) {
            $success = 'Preset applied successfully';
        } else {
            $error = 'Failed to apply preset';
        }
    }
}

$users = $userManager->getAllUsers();
$allPermissions = $permManager->getAllPermissions();

$pageTitle = 'Permissions - Galeriku ProMax';
$pageHeader = 'User Permissions';
include __DIR__ . '/../components/header.php';
?>

<?php if ($success): ?>
<div class="alert alert-success" style="margin-bottom: var(--spacing-xl);">
    <?php echo UIIcons::check('icon-sm'); ?>
    <span><?php echo htmlspecialchars($success); ?></span>
</div>
<?php endif; ?>

<div class="grid grid-auto">
    <?php foreach ($users as $user): ?>
        <?php 
        $username = $user['username'];
        $perms = $permManager->getUserPermissions($username);
        ?>
        <div class="card">
            <div class="flex items-center gap-md" style="margin-bottom: var(--spacing-lg);">
                <img src="../user-avatar.php?username=<?php echo urlencode($username); ?>" 
                     style="width: 48px; height: 48px; border-radius: 50%; border: 2px solid var(--border);">
                <div style="flex: 1;">
                    <h3 style="font-weight: 600;"><?php echo htmlspecialchars($username); ?></h3>
                    <p style="font-size: 0.875rem; color: var(--text-secondary);">
                        <?php echo $user['role'] === 'admin' ? 'Administrator' : 'User'; ?>
                    </p>
                </div>
            </div>
            
            <form method="POST" class="perm-form">
                <?php echo CSRF::field(); ?>
                <input type="hidden" name="action" value="update_permissions">
                <input type="hidden" name="username" value="<?php echo htmlspecialchars($username); ?>">
                
                <div class="perm-list">
                    <label class="perm-item">
                        <div class="flex items-center gap-sm">
                            <?php echo UIIcons::upload('icon-sm'); ?>
                            <span>Upload Images</span>
                        </div>
                        <input type="checkbox" name="can_upload" class="toggle" <?php echo $perms['can_upload'] ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="perm-item">
                        <div class="flex items-center gap-sm">
                            <?php echo UIIcons::folder('icon-sm'); ?>
                            <span>Create Folders</span>
                        </div>
                        <input type="checkbox" name="can_create_folders" class="toggle" <?php echo $perms['can_create_folders'] ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="perm-item">
                        <div class="flex items-center gap-sm">
                            <?php echo UIIcons::trash('icon-sm'); ?>
                            <span>Delete Content</span>
                        </div>
                        <input type="checkbox" name="can_delete" class="toggle" <?php echo $perms['can_delete'] ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="perm-item">
                        <div class="flex items-center gap-sm">
                            <?php echo UIIcons::globe('icon-sm'); ?>
                            <span>Share Publicly</span>
                        </div>
                        <input type="checkbox" name="can_share" class="toggle" <?php echo $perms['can_share'] ? 'checked' : ''; ?>>
                    </label>
                    
                    <label class="perm-item">
                        <div class="flex items-center gap-sm">
                            <?php echo UIIcons::download('icon-sm'); ?>
                            <span>Download Original</span>
                        </div>
                        <input type="checkbox" name="can_download_original" class="toggle" <?php echo $perms['can_download_original'] ? 'checked' : ''; ?>>
                    </label>
                </div>
                
                <div class="form-group" style="margin-top: var(--spacing-lg);">
                    <label class="form-label">Storage Quota</label>
                    <select name="storage_quota" class="form-select">
                        <option value="536870912" <?php echo $perms['storage_quota'] == 536870912 ? 'selected' : ''; ?>>512 MB</option>
                        <option value="1073741824" <?php echo $perms['storage_quota'] == 1073741824 ? 'selected' : ''; ?>>1 GB</option>
                        <option value="2147483648" <?php echo $perms['storage_quota'] == 2147483648 ? 'selected' : ''; ?>>2 GB</option>
                        <option value="5368709120" <?php echo $perms['storage_quota'] == 5368709120 ? 'selected' : ''; ?>>5 GB</option>
                        <option value="-1" <?php echo $perms['storage_quota'] == -1 ? 'selected' : ''; ?>>Unlimited</option>
                    </select>
                </div>
                
                <div class="flex gap-sm" style="margin-top: var(--spacing-md);">
                    <button type="submit" class="btn btn-primary btn-sm" style="flex: 1;">
                        <?php echo UIIcons::check('icon-sm'); ?>
                        <span>Save</span>
                    </button>
                </div>
            </form>
        </div>
    <?php endforeach; ?>
</div>

<style>
.alert { display: flex; align-items: center; gap: var(--spacing-sm); padding: var(--spacing-md); border-radius: var(--radius-md); border: 1px solid; }
.alert-success { background: rgba(16, 185, 129, 0.1); border-color: var(--success); color: var(--success); }
.perm-list { display: flex; flex-direction: column; gap: var(--spacing-sm); }
.perm-item { display: flex; align-items: center; justify-content: space-between; padding: var(--spacing-sm); border-radius: var(--radius-md); background: var(--bg-secondary); cursor: pointer; }
.toggle { width: 48px; height: 24px; appearance: none; background: var(--bg-hover); border: 1px solid var(--border); border-radius: 12px; position: relative; cursor: pointer; transition: all 0.3s; }
.toggle:checked { background: var(--primary); }
.toggle::before { content: ''; position: absolute; width: 18px; height: 18px; background: white; border-radius: 50%; top: 2px; left: 2px; transition: transform 0.3s; }
.toggle:checked::before { transform: translateX(24px); }
</style>

<?php include __DIR__ . '/../components/footer.php'; ?>
