<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/CSRF.php';
require_once __DIR__ . '/../../includes/FolderManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();
$folderManager = new FolderManager();

$folderId = $_GET['id'] ?? '';
$folder = $folderManager->getFolder($folderId);

if (!$folder || (!$folderManager->ownsFolder($folderId, $username) && !$isAdmin)) {
    header('Location: ../folders.php?error=access_denied');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'visibility' => $_POST['visibility'] ?? 'private',
        'description' => trim($_POST['description'] ?? '')
    ];
    
    if ($folderManager->updateFolder($folderId, $data)) {
        header('Location: ../folders.php?success=folder_updated');
        exit;
    } else {
        $error = 'Failed to update folder';
    }
}

$pageTitle = 'Edit Folder - Galeriku ProMax';
$pageHeader = 'Edit Folder';
include __DIR__ . '/../components/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <?php if ($error): ?>
    <div class="alert alert-error" style="margin-bottom: var(--spacing-lg);">
        <?php echo UIIcons::alertCircle('icon-sm'); ?>
        <span><?php echo htmlspecialchars($error); ?></span>
    </div>
    <?php endif; ?>
    
    <form method="POST">
        <?php echo CSRF::field(); ?>
        
        <div class="form-group">
            <label class="form-label">Name</label>
            <input type="text" name="name" class="form-input" value="<?php echo htmlspecialchars($folder['name']); ?>" required>
        </div>
        
        <div class="form-group">
            <label class="form-label">Visibility</label>
            <div class="radio-group">
                <label class="radio-card">
                    <input type="radio" name="visibility" value="private" <?php echo $folder['visibility'] === 'private' ? 'checked' : ''; ?>>
                    <div class="radio-content">
                        <?php echo UIIcons::lock(); ?>
                        <strong>Private</strong>
                    </div>
                </label>
                <label class="radio-card">
                    <input type="radio" name="visibility" value="shared" <?php echo $folder['visibility'] === 'shared' ? 'checked' : ''; ?>>
                    <div class="radio-content">
                        <?php echo UIIcons::globe(); ?>
                        <strong>Shared</strong>
                    </div>
                </label>
            </div>
        </div>
        
        <div class="form-group">
            <label class="form-label">Description</label>
            <textarea name="description" class="form-textarea" rows="3"><?php echo htmlspecialchars($folder['description']); ?></textarea>
        </div>
        
        <div class="flex gap-sm">
            <a href="../folders.php" class="btn btn-secondary" style="flex: 1;">Cancel</a>
            <button type="submit" class="btn btn-primary" style="flex: 1;">
                <?php echo UIIcons::check(); ?>
                <span>Save</span>
            </button>
        </div>
    </form>
</div>

<style>
.alert { display: flex; align-items: center; gap: var(--spacing-sm); padding: var(--spacing-md); border-radius: var(--radius-md); border: 1px solid; }
.alert-error { background: rgba(239, 68, 68, 0.1); border-color: var(--danger); color: var(--danger); }
.radio-group { display: grid; grid-template-columns: 1fr 1fr; gap: var(--spacing-md); }
.radio-card { position: relative; cursor: pointer; }
.radio-card input { position: absolute; opacity: 0; }
.radio-content { padding: var(--spacing-lg); border: 2px solid var(--border); border-radius: var(--radius-lg); text-align: center; transition: all 0.3s; }
.radio-content svg { width: 32px; height: 32px; color: var(--text-tertiary); }
.radio-card input:checked + .radio-content { border-color: var(--primary); background: rgba(139, 92, 246, 0.05); }
.radio-card input:checked + .radio-content svg { color: var(--primary); }
</style>

<?php include __DIR__ . '/../components/footer.php'; ?>
