<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/CSRF.php';
require_once __DIR__ . '/../../includes/FolderManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();
$folderManager = new FolderManager();

$folderId = $_GET['id'] ?? '';
$folder = $folderManager->getFolder($folderId);

if (!$folder || (!$folderManager->ownsFolder($folderId, $username) && !$isAdmin)) {
    header('Location: ../folders.php?error=access_denied');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $deleteImages = isset($_POST['delete_images']);
    
    if ($folderManager->deleteFolder($folderId, $deleteImages)) {
        header('Location: ../folders.php?success=folder_deleted');
        exit;
    }
}

$pageTitle = 'Delete Folder - Galeriku ProMax';
$pageHeader = 'Delete Folder';
include __DIR__ . '/../components/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="alert alert-error" style="margin-bottom: var(--spacing-lg);">
        <?php echo UIIcons::alertCircle(); ?>
        <div>
            <strong>Warning!</strong>
            <p style="margin-top: var(--spacing-xs);">This action cannot be undone.</p>
        </div>
    </div>
    
    <div style="text-align: center; margin-bottom: var(--spacing-xl);">
        <?php echo UIIcons::folder('icon-xl'); ?>
        <h2 style="margin: var(--spacing-md) 0;"><?php echo htmlspecialchars($folder['name']); ?></h2>
        <p style="color: var(--text-secondary);"><?php echo $folder['image_count']; ?> image(s) in this folder</p>
    </div>
    
    <form method="POST">
        <?php echo CSRF::field(); ?>
        
        <label class="checkbox-label" style="display: flex; align-items: center; gap: var(--spacing-sm); padding: var(--spacing-md); background: var(--bg-secondary); border-radius: var(--radius-md); cursor: pointer;">
            <input type="checkbox" name="delete_images">
            <span>Also delete all <?php echo $folder['image_count']; ?> image(s) in this folder</span>
        </label>
        
        <div class="form-help" style="margin-top: var(--spacing-sm);">
            If unchecked, images will be moved to gallery root
        </div>
        
        <div class="flex gap-sm" style="margin-top: var(--spacing-lg);">
            <a href="../folders.php" class="btn btn-secondary" style="flex: 1;">Cancel</a>
            <button type="submit" class="btn btn-danger" style="flex: 1;">
                <?php echo UIIcons::trash(); ?>
                <span>Delete Folder</span>
            </button>
        </div>
    </form>
</div>

<style>
.alert { display: flex; gap: var(--spacing-md); padding: var(--spacing-md); border-radius: var(--radius-md); border: 1px solid; }
.alert-error { background: rgba(239, 68, 68, 0.1); border-color: var(--danger); color: var(--danger); }
.alert svg { flex-shrink: 0; }
.checkbox-label input { width: 20px; height: 20px; }
</style>

<?php include __DIR__ . '/../components/footer.php'; ?>
