<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/CSRF.php';
require_once __DIR__ . '/../../includes/FolderManager.php';
require_once __DIR__ . '/../../includes/PermissionManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$folderManager = new FolderManager();
$permManager = new PermissionManager();

if (!$permManager->canCreateFolders($username)) {
    die('You do not have permission to create folders');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $name = trim($_POST['name'] ?? '');
    $visibility = $_POST['visibility'] ?? 'private';
    $description = trim($_POST['description'] ?? '');
    
    if (empty($name)) {
        $error = 'Folder name is required';
    } else {
        $result = $folderManager->createFolder($username, $name, $visibility, $description);
        if ($result) {
            header('Location: ../folders.php?success=folder_created');
            exit;
        } else {
            $error = 'Failed to create folder';
        }
    }
}

$pageTitle = 'Create Folder - Galeriku ProMax';
$pageHeader = 'Create New Folder';
include __DIR__ . '/../components/header.php';
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <?php if ($error): ?>
    <div class="alert alert-error" style="margin-bottom: var(--spacing-lg);">
        <?php echo UIIcons::alertCircle('icon-sm'); ?>
        <span><?php echo htmlspecialchars($error); ?></span>
    </div>
    <?php endif; ?>
    
    <form method="POST">
        <?php echo CSRF::field(); ?>
        
        <div class="form-group">
            <label class="form-label" for="name">Folder Name</label>
            <input type="text" id="name" name="name" class="form-input" required maxlength="50">
        </div>
        
        <div class="form-group">
            <label class="form-label">Visibility</label>
            <div class="radio-group">
                <label class="radio-card">
                    <input type="radio" name="visibility" value="private" checked>
                    <div class="radio-content">
                        <?php echo UIIcons::lock(); ?>
                        <strong>Private</strong>
                        <span>Only you</span>
                    </div>
                </label>
                <label class="radio-card">
                    <input type="radio" name="visibility" value="shared">
                    <div class="radio-content">
                        <?php echo UIIcons::globe(); ?>
                        <strong>Shared</strong>
                        <span>Everyone</span>
                    </div>
                </label>
            </div>
        </div>
        
        <div class="form-group">
            <label class="form-label" for="description">Description (Optional)</label>
            <textarea id="description" name="description" class="form-textarea" rows="3"></textarea>
        </div>
        
        <div class="flex gap-sm">
            <a href="../folders.php" class="btn btn-secondary" style="flex: 1;">Cancel</a>
            <button type="submit" class="btn btn-primary" style="flex: 1;">
                <?php echo UIIcons::check(); ?>
                <span>Create</span>
            </button>
        </div>
    </form>
</div>

<style>
.alert { display: flex; align-items: center; gap: var(--spacing-sm); padding: var(--spacing-md); border-radius: var(--radius-md); border: 1px solid; }
.alert-error { background: rgba(239, 68, 68, 0.1); border-color: var(--danger); color: var(--danger); }
.radio-group { display: grid; grid-template-columns: 1fr 1fr; gap: var(--spacing-md); }
.radio-card { position: relative; cursor: pointer; }
.radio-card input { position: absolute; opacity: 0; }
.radio-content { padding: var(--spacing-lg); border: 2px solid var(--border); border-radius: var(--radius-lg); text-align: center; transition: all 0.3s; }
.radio-content svg { width: 32px; height: 32px; margin-bottom: var(--spacing-sm); color: var(--text-tertiary); }
.radio-card input:checked + .radio-content { border-color: var(--primary); background: rgba(139, 92, 246, 0.05); }
.radio-card input:checked + .radio-content svg { color: var(--primary); }
</style>

<?php include __DIR__ . '/../components/footer.php'; ?>
