<?php
require_once '../includes/config.php';
require_once '../includes/Auth.php';
require_once '../includes/FolderManager.php';
require_once '../includes/ImageManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();
$folderManager = new FolderManager();
$imageManager = new ImageManager();

$query = $_GET['q'] ?? '';
$folders = [];
$images = [];

if (!empty($query)) {
    $folders = $folderManager->searchFolders($query, $username, $isAdmin);
    $images = $imageManager->searchImages($query, $username, $isAdmin);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Results - Galeriku ProMax</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        :root {
            --primary: #8B5CF6; --bg-dark: #0F172A; --bg-card: #1E293B;
            --bg-hover: #334155; --text-primary: #F1F5F9; --text-secondary: #94A3B8;
            --border: #334155;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, var(--bg-dark) 0%, #1a1a2e 100%);
            color: var(--text-primary); min-height: 100vh;
        }
        .header {
            background: var(--bg-card); border-bottom: 1px solid var(--border);
            padding: 1rem 2rem; position: sticky; top: 0; z-index: 100;
        }
        .header-content {
            max-width: 1400px; margin: 0 auto; display: flex;
            justify-content: space-between; align-items: center; gap: 1rem;
        }
        .search-form {
            flex: 1; max-width: 600px; position: relative;
        }
        .search-input {
            width: 100%; padding: 0.875rem 3rem 0.875rem 1rem;
            background: var(--bg-hover); border: 1px solid var(--border);
            border-radius: 0.5rem; color: var(--text-primary);
            font-size: 1rem;
        }
        .search-input:focus {
            outline: none; border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.1);
        }
        .search-btn {
            position: absolute; right: 0.5rem; top: 50%;
            transform: translateY(-50%); background: var(--primary);
            border: none; border-radius: 0.375rem; padding: 0.5rem 1rem;
            color: white; cursor: pointer; font-weight: 600;
        }
        .back-btn {
            padding: 0.5rem 1rem; background: var(--bg-hover);
            color: var(--text-primary); text-decoration: none;
            border-radius: 0.5rem; transition: all 0.3s;
        }
        .back-btn:hover { background: var(--primary); }
        .container { max-width: 1400px; margin: 0 auto; padding: 2rem; }
        .search-header {
            margin-bottom: 2rem;
        }
        .search-title {
            font-size: 2rem; margin-bottom: 0.5rem;
            background: linear-gradient(135deg, var(--primary) 0%, #EC4899 100%);
            -webkit-background-clip: text; -webkit-text-fill-color: transparent;
        }
        .search-subtitle { color: var(--text-secondary); }
        .section-title {
            font-size: 1.25rem; margin: 2rem 0 1rem;
            display: flex; align-items: center; gap: 0.5rem;
        }
        .result-count {
            background: var(--primary); color: white;
            padding: 0.25rem 0.75rem; border-radius: 0.375rem;
            font-size: 0.875rem; font-weight: 600;
        }
        .grid {
            display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 1.5rem;
        }
        .folder-card, .image-card {
            background: var(--bg-card); border: 1px solid var(--border);
            border-radius: 1rem; overflow: hidden; transition: all 0.3s;
            text-decoration: none; color: inherit; cursor: pointer;
        }
        .folder-card:hover, .image-card:hover {
            border-color: var(--primary); transform: translateY(-4px);
            box-shadow: 0 12px 24px rgba(139, 92, 246, 0.2);
        }
        .folder-thumb {
            width: 100%; height: 150px;
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.1) 0%, rgba(236, 72, 153, 0.1) 100%);
            display: flex; align-items: center; justify-content: center;
            font-size: 3rem;
        }
        .image-thumb {
            width: 100%; height: 180px;
            background: repeating-conic-gradient(#1E293B 0% 25%, #334155 0% 50%) 50% / 20px 20px;
            display: flex; align-items: center; justify-content: center;
        }
        .image-thumb img {
            max-width: 100%; max-height: 100%; object-fit: contain;
        }
        .card-content { padding: 1rem; }
        .card-title {
            font-weight: 600; margin-bottom: 0.5rem;
            overflow: hidden; text-overflow: ellipsis; white-space: nowrap;
        }
        .card-meta {
            color: var(--text-secondary); font-size: 0.875rem;
            display: flex; justify-content: space-between; align-items: center;
        }
        .badge {
            padding: 0.25rem 0.5rem; border-radius: 0.25rem;
            font-size: 0.75rem; font-weight: 600;
        }
        .badge-private { background: rgba(239, 68, 68, 0.2); color: #EF4444; }
        .badge-shared { background: rgba(16, 185, 129, 0.2); color: #10B981; }
        .empty-state {
            text-align: center; padding: 4rem 2rem;
        }
        .empty-icon { font-size: 5rem; margin-bottom: 1rem; opacity: 0.5; }
        .empty-title { font-size: 1.5rem; margin-bottom: 0.5rem; }
        @media (max-width: 768px) {
            .container { padding: 1rem; }
            .grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <a href="index.php" class="back-btn">← Back</a>
            <form class="search-form" method="GET">
                <input type="text" name="q" class="search-input" 
                       placeholder="Search folders and images..." 
                       value="<?php echo htmlspecialchars($query); ?>" 
                       autofocus required>
                <button type="submit" class="search-btn">🔍 Search</button>
            </form>
        </div>
    </div>

    <div class="container">
        <div class="search-header">
            <h1 class="search-title">Search Results</h1>
            <?php if (!empty($query)): ?>
                <p class="search-subtitle">
                    Showing results for: <strong>"<?php echo htmlspecialchars($query); ?>"</strong>
                </p>
            <?php endif; ?>
        </div>

        <?php if (empty($query)): ?>
            <div class="empty-state">
                <div class="empty-icon">🔍</div>
                <h2 class="empty-title">Start searching</h2>
                <p style="color: var(--text-secondary);">
                    Enter keywords to search for folders and images
                </p>
            </div>
        <?php elseif (empty($folders) && empty($images)): ?>
            <div class="empty-state">
                <div class="empty-icon">😕</div>
                <h2 class="empty-title">No results found</h2>
                <p style="color: var(--text-secondary);">
                    Try different keywords or check your spelling
                </p>
            </div>
        <?php else: ?>
            
            <?php if (!empty($folders)): ?>
                <h2 class="section-title">
                    📁 Folders 
                    <span class="result-count"><?php echo count($folders); ?></span>
                </h2>
                <div class="grid">
                    <?php foreach ($folders as $folder): ?>
                        <a href="folder-view.php?id=<?php echo urlencode($folder['id']); ?>" class="folder-card">
                            <div class="folder-thumb">📁</div>
                            <div class="card-content">
                                <div class="card-title"><?php echo htmlspecialchars($folder['name']); ?></div>
                                <div class="card-meta">
                                    <span>🖼️ <?php echo $folder['image_count']; ?> images</span>
                                    <span class="badge <?php echo $folder['visibility'] === 'private' ? 'badge-private' : 'badge-shared'; ?>">
                                        <?php echo $folder['visibility'] === 'private' ? '🔒' : '🌐'; ?>
                                    </span>
                                </div>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($images)): ?>
                <h2 class="section-title">
                    🖼️ Images 
                    <span class="result-count"><?php echo count($images); ?></span>
                </h2>
                <div class="grid">
                    <?php foreach ($images as $image): ?>
                        <div class="image-card" onclick="window.location.href='index.php?highlight=<?php echo urlencode($image['filename']); ?>'">
                            <div class="image-thumb">
                                <img src="image.php?file=<?php echo urlencode($image['filename']); ?>&username=<?php echo urlencode($image['owner']); ?>" 
                                     alt="<?php echo htmlspecialchars($image['filename']); ?>" loading="lazy">
                            </div>
                            <div class="card-content">
                                <div class="card-title"><?php echo htmlspecialchars($image['filename']); ?></div>
                                <div class="card-meta">
                                    <span>👤 <?php echo htmlspecialchars($image['owner']); ?></span>
                                    <span class="badge <?php echo $image['visibility'] === 'private' ? 'badge-private' : 'badge-shared'; ?>">
                                        <?php echo $image['visibility'] === 'private' ? '🔒' : '🌐'; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

        <?php endif; ?>
    </div>
</body>
</html>
