<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/Auth.php';
require_once __DIR__ . '/../includes/PngHandler.php';

// Require login
Auth::requireLogin();

$type = $_GET['type'] ?? 'optimized'; // original, optimized, thumb
$file = $_GET['file'] ?? '';
$download = isset($_GET['download']);

if (empty($file)) {
    http_response_code(400);
    die('Filename required');
}

// Sanitize filename
$file = basename($file);

// Get current user
$username = Auth::getUsername();

// Determine path based on type
$validTypes = ['original' => 'originals', 'optimized' => 'optimized', 'thumb' => 'thumbs'];

if (!isset($validTypes[$type])) {
    $type = 'optimized';
}

$folder = $validTypes[$type];
$imagePath = USERS_PATH . '/' . $username . '/' . $folder . '/' . $file;

// Check if file exists
if (!file_exists($imagePath)) {
    http_response_code(404);
    die('Image not found');
}

// Check if user owns this file or is admin
if (!Auth::ownsResource($username) && !Auth::isAdmin()) {
    http_response_code(403);
    die('Access denied');
}

// Output image
$handler = new PngHandler();
$handler->output($imagePath, $download);
