<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/PngHandler.php';

Auth::requireLogin();

$file = $_GET['file'] ?? '';
$newName = $_GET['new_name'] ?? '';

if (empty($file) || empty($newName)) {
    header('Location: ../index.php?error=invalid_params');
    exit;
}

$username = Auth::getUsername();
$userId = Auth::getUserId();
$handler = new PngHandler($userId, $username);

$result = $handler->rename($file, $newName, $username);

if (isset($result['success']) && $result['success']) {
    header('Location: ../index.php?renamed=1');
} else {
    $error = $result['error'] ?? 'Unknown error';
    header('Location: ../index.php?error=' . urlencode($error));
}
exit;
