<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/Auth.php';
require_once __DIR__ . '/../../includes/PngHandler.php';

Auth::requireLogin();

$file = $_GET['file'] ?? '';
$confirm = $_GET['confirm'] ?? '';

if (empty($file)) {
    header('Location: ../index.php');
    exit;
}

$username = Auth::getUsername();
$userId = Auth::getUserId();
$handler = new PngHandler($userId, $username);

if ($confirm === '1') {
    if ($handler->delete($file, $username)) {
        header('Location: ../index.php?deleted=1');
    } else {
        header('Location: ../index.php?error=delete_failed');
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Confirmation</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <script>
        Swal.fire({
            title: 'Delete this image?',
            text: 'This action cannot be undone!',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#EF4444',
            cancelButtonColor: '#6B7280',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = 'delete.php?file=<?php echo urlencode($file); ?>&confirm=1';
            } else {
                window.location.href = '../index.php';
            }
        });
    </script>
</body>
</html>
