<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/Auth.php';
require_once __DIR__ . '/../includes/CSRF.php';
require_once __DIR__ . '/../includes/UserManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$userManager = new UserManager();
$currentUser = Auth::getCurrentUser();

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    CSRF::verifyOrDie();
    
    $action = $_POST['action'] ?? '';
    
    if ($action === 'change_password') {
        $currentPassword = $_POST['current_password'] ?? '';
        $newPassword = $_POST['new_password'] ?? '';
        $confirmPassword = $_POST['confirm_password'] ?? '';
        
        if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
            $error = 'All fields are required';
        } elseif ($newPassword !== $confirmPassword) {
            $error = 'New passwords do not match';
        } elseif (strlen($newPassword) < 6) {
            $error = 'Password must be at least 6 characters';
        } elseif (!Auth::login($username, $currentPassword)) {
            $error = 'Current password is incorrect';
        } else {
            if ($userManager->updatePassword($username, $newPassword)) {
                $success = 'Password changed successfully';
            } else {
                $error = 'Failed to change password';
            }
        }
    }
}

$pageTitle = 'Settings - Galeriku ProMax';
$pageHeader = 'Settings';
include __DIR__ . '/components/header.php';
?>

<?php if ($success): ?>
<div class="alert alert-success" style="margin-bottom: var(--spacing-xl);">
    <?php echo UIIcons::check('icon-sm'); ?>
    <span><?php echo htmlspecialchars($success); ?></span>
</div>
<?php endif; ?>

<?php if ($error): ?>
<div class="alert alert-error" style="margin-bottom: var(--spacing-xl);">
    <?php echo UIIcons::alertCircle('icon-sm'); ?>
    <span><?php echo htmlspecialchars($error); ?></span>
</div>
<?php endif; ?>

<div class="grid grid-2">
    <!-- Profile Info -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Profile Information</h2>
        </div>
        <div class="card-body">
            <div class="flex items-center gap-lg" style="margin-bottom: var(--spacing-xl);">
                <img src="user-avatar.php?username=<?php echo urlencode($username); ?>" 
                     alt="Avatar" 
                     style="width: 80px; height: 80px; border-radius: 50%; border: 3px solid var(--border);">
                <div>
                    <h3 style="font-size: 1.25rem; font-weight: 700; margin-bottom: var(--spacing-xs);">
                        <?php echo htmlspecialchars($username); ?>
                    </h3>
                    <p style="color: var(--text-secondary); margin-bottom: var(--spacing-xs);">
                        <?php echo htmlspecialchars($currentUser['email'] ?? 'No email set'); ?>
                    </p>
                    <span class="badge badge-<?php echo Auth::isAdmin() ? 'primary' : 'info'; ?>">
                        <?php echo Auth::isAdmin() ? 'Administrator' : 'User'; ?>
                    </span>
                </div>
            </div>
            
            <div class="flex flex-col gap-md">
                <div>
                    <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase; margin-bottom: var(--spacing-xs);">Storage Used</div>
                    <div style="font-size: 1.125rem; font-weight: 600;"><?php echo formatBytes($currentUser['storage_used'] ?? 0); ?></div>
                </div>
                <div>
                    <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase; margin-bottom: var(--spacing-xs);">Total Uploads</div>
                    <div style="font-size: 1.125rem; font-weight: 600;"><?php echo $currentUser['total_uploads'] ?? 0; ?></div>
                </div>
                <div>
                    <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase; margin-bottom: var(--spacing-xs);">Member Since</div>
                    <div style="font-size: 1.125rem; font-weight: 600;"><?php echo date('M Y', strtotime($currentUser['created'] ?? 'now')); ?></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Change Password -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Change Password</h2>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <?php echo CSRF::field(); ?>
                <input type="hidden" name="action" value="change_password">
                
                <div class="form-group">
                    <label class="form-label" for="current_password">Current Password</label>
                    <div class="input-group">
                        <span class="input-icon"><?php echo UIIcons::lock('icon-sm'); ?></span>
                        <input 
                            type="password" 
                            id="current_password" 
                            name="current_password" 
                            class="form-input input-with-icon" 
                            required
                        >
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="new_password">New Password</label>
                    <div class="input-group">
                        <span class="input-icon"><?php echo UIIcons::lock('icon-sm'); ?></span>
                        <input 
                            type="password" 
                            id="new_password" 
                            name="new_password" 
                            class="form-input input-with-icon" 
                            required
                            minlength="6"
                        >
                    </div>
                    <div class="form-help">Minimum 6 characters</div>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="confirm_password">Confirm New Password</label>
                    <div class="input-group">
                        <span class="input-icon"><?php echo UIIcons::lock('icon-sm'); ?></span>
                        <input 
                            type="password" 
                            id="confirm_password" 
                            name="confirm_password" 
                            class="form-input input-with-icon" 
                            required
                        >
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    <?php echo UIIcons::check(); ?>
                    <span>Change Password</span>
                </button>
            </form>
        </div>
    </div>
</div>

<style>
.alert {
    display: flex;
    align-items: center;
    gap: var(--spacing-sm);
    padding: var(--spacing-md);
    border-radius: var(--radius-md);
    border: 1px solid;
}
.alert-success {
    background: rgba(16, 185, 129, 0.1);
    border-color: rgba(16, 185, 129, 0.3);
    color: var(--success);
}
.alert-error {
    background: rgba(239, 68, 68, 0.1);
    border-color: rgba(239, 68, 68, 0.3);
    color: var(--danger);
}
.input-group { position: relative; }
.input-icon { position: absolute; left: 0.875rem; top: 50%; transform: translateY(-50%); color: var(--text-tertiary); }
.input-with-icon { padding-left: 2.75rem; }
</style>

<?php include __DIR__ . '/components/footer.php'; ?>
