<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/Auth.php';
require_once __DIR__ . '/../includes/FolderManager.php';
require_once __DIR__ . '/../includes/PermissionManager.php';

Auth::requireLogin();

$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();

$folderManager = new FolderManager();
$permManager = new PermissionManager();

// Get view mode
$view = $_GET['view'] ?? 'my';

// Get folders based on view mode
if ($view === 'shared') {
    $folders = $folderManager->getSharedFolders();
} else {
    $folders = $folderManager->getUserFolders($username);
}

// Get stats
$stats = $folderManager->getFolderStats($username);
$canCreateFolders = $permManager->canCreateFolders($username);

// Page config
$pageTitle = 'Folders - Galeriku ProMax';
$pageHeader = 'Folders';

// Include header
include __DIR__ . '/components/header.php';

// Success messages
$success = $_GET['success'] ?? '';
?>

<?php if ($success): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const messages = {
        'folder_created': 'Folder created successfully!',
        'folder_updated': 'Folder updated successfully!',
        'folder_deleted': 'Folder deleted successfully!'
    };
    
    if (messages['<?php echo $success; ?>']) {
        alert(messages['<?php echo $success; ?>']);
    }
});
</script>
<?php endif; ?>

<!-- Stats Cards -->
<div class="grid grid-4" style="margin-bottom: var(--spacing-xl);">
    <div class="card">
        <div class="flex items-center gap-md">
            <div style="width: 48px; height: 48px; border-radius: var(--radius-lg); background: linear-gradient(135deg, rgba(139, 92, 246, 0.15), rgba(236, 72, 153, 0.15)); display: flex; align-items: center; justify-content: center;">
                <?php echo UIIcons::folder('icon-lg'); ?>
            </div>
            <div>
                <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase;">Total Folders</div>
                <div style="font-size: 1.5rem; font-weight: 700; color: var(--primary);"><?php echo $stats['total']; ?></div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="flex items-center gap-md">
            <div style="width: 48px; height: 48px; border-radius: var(--radius-lg); background: linear-gradient(135deg, rgba(239, 68, 68, 0.15), rgba(220, 38, 38, 0.15)); display: flex; align-items: center; justify-content: center;">
                <?php echo UIIcons::lock('icon-lg'); ?>
            </div>
            <div>
                <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase;">Private</div>
                <div style="font-size: 1.5rem; font-weight: 700; color: var(--danger);"><?php echo $stats['private']; ?></div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="flex items-center gap-md">
            <div style="width: 48px; height: 48px; border-radius: var(--radius-lg); background: linear-gradient(135deg, rgba(16, 185, 129, 0.15), rgba(6, 182, 212, 0.15)); display: flex; align-items: center; justify-content: center;">
                <?php echo UIIcons::globe('icon-lg'); ?>
            </div>
            <div>
                <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase;">Shared</div>
                <div style="font-size: 1.5rem; font-weight: 700; color: var(--success);"><?php echo $stats['shared']; ?></div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="flex items-center gap-md">
            <div style="width: 48px; height: 48px; border-radius: var(--radius-lg); background: linear-gradient(135deg, rgba(59, 130, 246, 0.15), rgba(139, 92, 246, 0.15)); display: flex; align-items: center; justify-content: center;">
                <?php echo UIIcons::image('icon-lg'); ?>
            </div>
            <div>
                <div style="font-size: 0.75rem; color: var(--text-secondary); font-weight: 600; text-transform: uppercase;">Total Images</div>
                <div style="font-size: 1.5rem; font-weight: 700; color: var(--info);"><?php echo $stats['images']; ?></div>
            </div>
        </div>
    </div>
</div>

<!-- Actions Bar -->
<div class="card" style="margin-bottom: var(--spacing-xl);">
    <div class="flex items-center justify-between">
        <div class="flex gap-sm">
            <a href="?view=my" class="btn <?php echo $view === 'my' ? 'btn-primary' : 'btn-secondary'; ?> btn-sm">
                <?php echo UIIcons::lock('icon-sm'); ?>
                <span>My Folders</span>
            </a>
            <a href="?view=shared" class="btn <?php echo $view === 'shared' ? 'btn-primary' : 'btn-secondary'; ?> btn-sm">
                <?php echo UIIcons::globe('icon-sm'); ?>
                <span>Shared Gallery</span>
            </a>
        </div>
        
        <?php if ($canCreateFolders): ?>
            <a href="admin/folder-create.php" class="btn btn-primary btn-sm">
                <?php echo UIIcons::plus('icon-sm'); ?>
                <span>Create Folder</span>
            </a>
        <?php endif; ?>
    </div>
</div>

<!-- Folders Grid -->
<?php if (!empty($folders)): ?>
    <div class="grid grid-auto">
        <?php foreach ($folders as $folder): ?>
            <div class="card card-hover">
                <a href="folder-view.php?id=<?php echo urlencode($folder['id']); ?>" style="text-decoration: none; color: inherit; display: block;">
                    <div class="folder-thumbnail">
                        <?php if ($folder['thumbnail']): ?>
                            <img src="image.php?file=<?php echo urlencode($folder['thumbnail']); ?>&username=<?php echo urlencode($folder['owner']); ?>" alt="Thumbnail">
                        <?php else: ?>
                            <?php echo UIIcons::folder('folder-icon'); ?>
                        <?php endif; ?>
                    </div>
                    
                    <div class="folder-info">
                        <div class="flex items-center justify-between" style="margin-bottom: var(--spacing-sm);">
                            <h3 class="folder-title"><?php echo htmlspecialchars($folder['name']); ?></h3>
                            <span class="badge badge-<?php echo $folder['visibility'] === 'private' ? 'danger' : 'success'; ?>">
                                <?php echo $folder['visibility'] === 'private' ? UIIcons::lock('icon-sm') : UIIcons::globe('icon-sm'); ?>
                            </span>
                        </div>
                        
                        <?php if ($folder['description']): ?>
                            <p class="folder-description"><?php echo htmlspecialchars($folder['description']); ?></p>
                        <?php endif; ?>
                        
                        <div class="folder-meta">
                            <span><?php echo UIIcons::image('icon-sm'); ?> <?php echo $folder['image_count']; ?> images</span>
                            <span><?php echo UIIcons::users('icon-sm'); ?> <?php echo htmlspecialchars($folder['owner']); ?></span>
                        </div>
                    </div>
                </a>
                
                <?php if ($folderManager->ownsFolder($folder['id'], $username) || $isAdmin): ?>
                    <div class="folder-actions">
                        <a href="admin/folder-edit.php?id=<?php echo urlencode($folder['id']); ?>" class="btn btn-secondary btn-sm" onclick="event.stopPropagation();">
                            <?php echo UIIcons::edit('icon-sm'); ?>
                        </a>
                        <a href="admin/folder-delete.php?id=<?php echo urlencode($folder['id']); ?>" class="btn btn-secondary btn-sm" onclick="event.stopPropagation();">
                            <?php echo UIIcons::trash('icon-sm'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
<?php else: ?>
    <div class="empty-state">
        <?php echo UIIcons::folder('empty-icon'); ?>
        <h3 class="empty-title">No folders found</h3>
        <p class="empty-text">
            <?php if ($view === 'shared'): ?>
                There are no shared folders yet.
            <?php else: ?>
                Create your first folder to organize your images!
            <?php endif; ?>
        </p>
        <?php if ($canCreateFolders): ?>
            <a href="admin/folder-create.php" class="btn btn-primary">
                <?php echo UIIcons::plus(); ?>
                <span>Create Folder</span>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>

<style>
.folder-thumbnail {
    width: 100%;
    height: 180px;
    background: linear-gradient(135deg, rgba(139, 92, 246, 0.1) 0%, rgba(236, 72, 153, 0.1) 100%);
    border-radius: var(--radius-lg);
    margin-bottom: var(--spacing-md);
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}

.folder-thumbnail img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.folder-icon {
    width: 64px;
    height: 64px;
    color: var(--primary);
    opacity: 0.5;
}

.folder-info {
    flex: 1;
}

.folder-title {
    font-size: 1.125rem;
    font-weight: 600;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.folder-description {
    font-size: 0.875rem;
    color: var(--text-secondary);
    margin-bottom: var(--spacing-sm);
    overflow: hidden;
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
}

.folder-meta {
    display: flex;
    align-items: center;
    gap: var(--spacing-md);
    font-size: 0.8125rem;
    color: var(--text-tertiary);
    margin-top: var(--spacing-md);
    padding-top: var(--spacing-md);
    border-top: 1px solid var(--border);
}

.folder-meta span {
    display: flex;
    align-items: center;
    gap: var(--spacing-xs);
}

.folder-actions {
    display: flex;
    gap: var(--spacing-sm);
    margin-top: var(--spacing-md);
    padding-top: var(--spacing-md);
    border-top: 1px solid var(--border);
}
</style>

<?php include __DIR__ . '/components/footer.php'; ?>
