<?php
/**
 * Header Component
 * Unified header for all pages
 */

require_once __DIR__ . '/../../includes/ui-config.php';

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$username = Auth::getUsername();
$isAdmin = Auth::isAdmin();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Galeriku ProMax'; ?></title>
    <meta name="robots" content="noindex">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/main.css">
    <script src="/assets/js/theme.js"></script>
    <?php if (isset($additionalCSS)): ?>
        <?php foreach ($additionalCSS as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <a href="/index.php" class="logo">Galeriku ProMax</a>
            </div>
            
            <nav class="sidebar-nav">
                <!-- Main Navigation -->
                <div class="nav-section">
                    <div class="nav-section-title">Main</div>
                    <a href="/index.php" class="nav-item <?php echo $currentPage === 'index' ? 'active' : ''; ?>">
                        <?php echo UIIcons::image(); ?>
                        <span>Gallery</span>
                    </a>
                    <a href="/folders.php" class="nav-item <?php echo $currentPage === 'folders' ? 'active' : ''; ?>">
                        <?php echo UIIcons::folder(); ?>
                        <span>Folders</span>
                    </a>
                    <a href="/search.php" class="nav-item <?php echo $currentPage === 'search' ? 'active' : ''; ?>">
                        <?php echo UIIcons::search(); ?>
                        <span>Search</span>
                    </a>
                    <a href="/admin/upload.php" class="nav-item <?php echo $currentPage === 'upload' ? 'active' : ''; ?>">
                        <?php echo UIIcons::upload(); ?>
                        <span>Upload</span>
                    </a>
                </div>
                
                <!-- Admin Navigation -->
                <?php if ($isAdmin): ?>
                <div class="nav-section">
                    <div class="nav-section-title">Admin</div>
                    <a href="/admin/users.php" class="nav-item <?php echo $currentPage === 'users' ? 'active' : ''; ?>">
                        <?php echo UIIcons::users(); ?>
                        <span>Users</span>
                    </a>
                    <a href="/admin/permissions.php" class="nav-item <?php echo $currentPage === 'permissions' ? 'active' : ''; ?>">
                        <?php echo UIIcons::shield(); ?>
                        <span>Permissions</span>
                    </a>
                </div>
                <?php endif; ?>
                
                <!-- Settings -->
                <div class="nav-section">
                    <div class="nav-section-title">Account</div>
                    <a href="/settings.php" class="nav-item <?php echo $currentPage === 'settings' ? 'active' : ''; ?>">
                        <?php echo UIIcons::settings(); ?>
                        <span>Settings</span>
                    </a>
                    <a href="/logout.php" class="nav-item">
                        <?php echo UIIcons::logout(); ?>
                        <span>Logout</span>
                    </a>
                </div>
            </nav>
            
            <div class="sidebar-footer">
                <div class="nav-item" style="cursor: default; pointer-events: none;">
                    <img src="/user-avatar.php?username=<?php echo urlencode($username); ?>" 
                         alt="Avatar" 
                         style="width: 32px; height: 32px; border-radius: 50%; border: 2px solid var(--border);">
                    <div style="flex: 1; min-width: 0;">
                        <div style="font-weight: 600; font-size: 0.875rem; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                            <?php echo htmlspecialchars($username); ?>
                        </div>
                        <div style="font-size: 0.75rem; color: var(--text-tertiary);">
                            <?php echo $isAdmin ? 'Administrator' : 'User'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </aside>
        
        <!-- Sidebar Overlay (Mobile) -->
        <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <header class="header">
                <div class="header-content">
                    <div class="header-left">
                        <button class="btn btn-icon btn-secondary" onclick="toggleSidebar()" style="display: none;" id="menuToggle">
                            <?php echo UIIcons::menu(); ?>
                        </button>
                        <?php if (isset($pageHeader)): ?>
                            <h1 style="font-size: 1.5rem; font-weight: 700;"><?php echo $pageHeader; ?></h1>
                        <?php endif; ?>
                    </div>
                    
                    <div class="header-right">
                        <!-- Theme Toggle -->
                        <button class="theme-toggle" data-theme-toggle aria-label="Toggle theme">
                            <div class="theme-toggle-slider">
                                <span class="theme-icon-sun"><?php echo UIIcons::sun('icon-sm'); ?></span>
                                <span class="theme-icon-moon" style="display: none;"><?php echo UIIcons::moon('icon-sm'); ?></span>
                            </div>
                        </button>
                        
                        <!-- Upload Button (Quick Action) -->
                        <a href="/admin/upload.php" class="btn btn-primary btn-sm">
                            <?php echo UIIcons::upload('icon-sm'); ?>
                            <span>Upload</span>
                        </a>
                    </div>
                </div>
            </header>
            
            <!-- Page Content -->
            <div class="content-wrapper">
<?php
// Content will be inserted here by including pages
?>
