<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/UserManager.php';

$username = $_GET['username'] ?? '';

if (empty($username)) {
    http_response_code(400);
    die('Username required');
}

$userManager = new UserManager();
$avatarPath = $userManager->getAvatarPath($username);

// If no avatar, show default
if (!$avatarPath || !file_exists($avatarPath)) {
    // Generate default avatar with initials
    $initial = strtoupper(substr($username, 0, 1));
    
    $img = imagecreatetruecolor(200, 200);
    
    // Random color based on username
    $hash = md5($username);
    $r = hexdec(substr($hash, 0, 2));
    $g = hexdec(substr($hash, 2, 2));
    $b = hexdec(substr($hash, 4, 2));
    
    $bgColor = imagecolorallocate($img, $r, $g, $b);
    $textColor = imagecolorallocate($img, 255, 255, 255);
    
    imagefilledrectangle($img, 0, 0, 200, 200, $bgColor);
    
    // Add text
    $font = 5; // Built-in font
    $textWidth = imagefontwidth($font) * strlen($initial);
    $textHeight = imagefontheight($font);
    $x = (200 - $textWidth) / 2;
    $y = (200 - $textHeight) / 2;
    
    // Draw initial (larger, centered)
    for ($size = 1; $size <= 8; $size++) {
        imagestring($img, $font, $x + ($size * 3), $y + ($size * 2), $initial, $textColor);
    }
    
    header('Content-Type: image/png');
    header('Cache-Control: public, max-age=3600');
    imagepng($img, null, 6);
    imagedestroy($img);
    exit;
}

// Output user avatar
header('Content-Type: image/png');
header('Content-Length: ' . filesize($avatarPath));
header('Cache-Control: public, max-age=3600');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 3600) . ' GMT');

readfile($avatarPath);
exit;
