# 🎨 GALERIKU PROMAX v2.0

Modern PNG Gallery System dengan Multi-User Support, Activity Logging, dan Per-User Storage Management.

## ✨ FITUR UTAMA

### 🔐 User Management
- **Unique User ID System** - Setiap user punya ID unik
- **Role-Based Access** - Admin & User roles
- **Profile Management** - Edit display name, email, bio
- **Avatar System** - Upload & manage profile pictures
- **Username Change** - Ubah username dengan data migration

### 📁 Storage Management  
- **Per-User Folders** - Setiap user punya folder sendiri
- **Storage Tracking** - Monitor penggunaan storage real-time
- **Auto Organization** - File terorganisir otomatis
- **Upload Counter** - Track jumlah upload per user

### 🖼️ Image Handling
- **PNG Transparency** - Alpha channel preserved 100%
- **Auto Optimization** - Compress tanpa loss quality
- **Thumbnail Generation** - Auto create thumbs
- **Rename & Delete** - Manage files dengan mudah
- **Bulk Operations** - Coming soon!

### 📊 Activity Logging
- **Login History** - Track semua login attempts
- **Activity Log** - Record semua user actions
- **Failed Attempts** - Monitor security
- **User Statistics** - Dashboard analytics

### 🔒 Security
- **CSRF Protection** - Token validation
- **Session Management** - Secure sessions
- **Input Validation** - Prevent injection
- **File Type Check** - Only PNG allowed
- **Access Control** - Resource ownership check

### 🎨 Modern UI/UX
- **Responsive Design** - Mobile-friendly
- **Dark Mode** - Eye-friendly theme
- **Smooth Animations** - Buttery smooth
- **Modern Icons** - Beautiful SVG icons
- **Clean Interface** - Intuitive design

## 📦 STRUKTUR FILE

```
galeriku-promax/
├── includes/
│   ├── config.php          # Configuration & helpers
│   ├── Auth.php            # Authentication system
│   ├── CSRF.php            # CSRF protection
│   ├── UserManager.php     # User management
│   └── PngHandler.php      # Image processing
├── public/
│   ├── login.php           # Login page
│   ├── index.php           # Gallery view (TODO)
│   ├── logout.php          # Logout handler
│   ├── image.php           # Image viewer
│   ├── user-avatar.php     # Avatar handler
│   └── admin/
│       ├── upload.php      # Upload interface (TODO)
│       ├── users.php       # User management (TODO)
│       ├── delete.php      # Delete handler (TODO)
│       └── rename.php      # Rename handler (TODO)
└── storage/
    ├── users/              # Per-user storage
    │   ├── admin/
    │   │   ├── originals/
    │   │   ├── optimized/
    │   │   ├── thumbs/
    │   │   └── avatar.png
    │   └── username/
    │       └── ...
    ├── users.json          # User database
    ├── login_history.json  # Login tracking
    └── activity_log.json   # Activity tracking
```

## 🚀 INSTALASI

### 1. Upload Files
```bash
# Upload ke server via FTP/cPanel File Manager
# Lokasi: public_html/galeriku-promax/
```

### 2. Set Permissions
```bash
chmod 755 public/
chmod 755 includes/
chmod 777 storage/ -R
chmod 777 storage/users/ -R
```

### 3. Access Application
```
http://yourdomain.com/galeriku-promax/public/login.php
```

### 4. Default Login
```
Username: admin
Password: password
```

### 5. Change Password!
Setelah login pertama kali, **SEGERA** ubah password default di Settings.

## ⚙️ KONFIGURASI

### File: `includes/config.php`

```php
// Timezone
date_default_timezone_set('Asia/Jakarta');

// HTTPS (jika sudah pasang SSL)
ini_set('session.cookie_secure', 1);

// URL Configuration (auto-detected)
// Atau set manual jika perlu
```

### Database
Sistem ini menggunakan **JSON files** untuk storage, tidak perlu MySQL!

## 🔧 BUG FIXES v2.0

### ✅ Fixed Issues:
1. **User ID Inconsistency** → Unique ID system
2. **Total Counter Wrong** → Accurate tracking
3. **Avatar Upload Fails** → Improved processing
4. **Username Change Bugs** → Proper migration
5. **Storage Calculation** → Real file sizes
6. **CSRF Validation** → Better security
7. **Session Timeout** → Proper handling
8. **Permission Errors** → Auto-create dirs

## 📝 CHANGELOG

### Version 2.0 ProMax (November 2024)
- ✅ Complete rewrite of user management
- ✅ Implemented unique user ID system
- ✅ Per-user storage organization
- ✅ Activity logging system
- ✅ Login history tracking
- ✅ Modern UI with new SVG icons
- ✅ Better error handling
- ✅ Improved security
- ✅ Auto backup system
- ✅ Storage tracking

### Version 1.0 (Previous)
- Basic gallery functionality
- Multi-user support
- PNG upload & optimization
- Simple authentication

## 🎯 TODO / ROADMAP

### Priority High
- [ ] Complete Index.php (Gallery view)
- [ ] Upload interface with drag & drop
- [ ] Admin user management panel
- [ ] Settings page per user
- [ ] Delete & rename handlers

### Priority Medium
- [ ] Bulk operations (select multiple)
- [ ] Search & filter images
- [ ] Grid/List view toggle
- [ ] Keyboard shortcuts
- [ ] Share functionality

### Priority Low
- [ ] Image filters/effects
- [ ] Export/Download multiple
- [ ] API endpoints
- [ ] Mobile app version

## 🐛 TROUBLESHOOTING

### Error: "Failed to create directory"
```bash
# Fix permissions
chmod 777 storage/ -R
```

### Error: "CSRF token validation failed"
```php
// Clear browser cache & cookies
// Or regenerate session
session_destroy();
```

### Error: "File not found"
```bash
# Check file paths in config.php
# Pastikan BASE_PATH sudah benar
```

### Images tidak muncul
```bash
# Check .htaccess di storage/
# Pastikan tidak ada deny rules
```

## 💡 TIPS & TRICKS

### Untuk Admin:
1. Selalu backup `storage/users.json` secara berkala
2. Monitor `storage/error.log` untuk track issues
3. Review activity logs regularly
4. Set proper file size limits di config

### Untuk Developer:
1. All classes are autoloaded
2. Use helper functions in config.php
3. Follow existing code patterns
4. Test in development first

## 📞 SUPPORT

### Jika ada masalah:
1. Check `storage/error.log`
2. Verify file permissions
3. Clear browser cache
4. Regenerate session
5. Check PHP version (min 7.4)

### Requirements:
- PHP 7.4 or higher
- GD Library (for image processing)
- JSON support (built-in)
- Apache/Nginx web server
- Modern browser (Chrome, Firefox, Safari)

## 📄 LICENSE

Proprietary - Created by ImmortalDev
All rights reserved.

## 🙏 CREDITS

- **Developer**: ImmortalDev
- **Version**: 2.0 ProMax
- **Date**: November 2024
- **Icons**: Custom SVG icons
- **Fonts**: Google Fonts (Inter)

---

**Built with ❤️ for modern web**
