<?php
/**
 * User Avatar Server
 * Serves user avatars with fallback to default SVG
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';

// Require login
Auth::requireLogin();

$username = $_GET['user'] ?? Auth::getUsername();
$avatarPath = STORAGE_PATH . '/users/' . $username . '/avatar.png';

if (!file_exists($avatarPath)) {
    // Return default avatar SVG with user's initials
    $initials = strtoupper(substr($username, 0, 2));
    
    // Generate color based on username
    $hash = md5($username);
    $hue = hexdec(substr($hash, 0, 2)) / 255 * 360;
    
    header('Content-Type: image/svg+xml');
    header('Cache-Control: public, max-age=3600');
    
    echo '<?xml version="1.0" encoding="UTF-8"?>';
    echo '<svg viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">';
    echo '<defs>';
    echo '<linearGradient id="grad" x1="0%" y1="0%" x2="100%" y2="100%">';
    echo '<stop offset="0%" style="stop-color:hsl(' . $hue . ', 70%, 60%);stop-opacity:1" />';
    echo '<stop offset="100%" style="stop-color:hsl(' . ($hue + 30) . ', 70%, 50%);stop-opacity:1" />';
    echo '</linearGradient>';
    echo '</defs>';
    echo '<circle cx="100" cy="100" r="100" fill="url(#grad)"/>';
    echo '<text x="100" y="125" font-family="Arial, sans-serif" font-size="80" font-weight="bold" fill="white" text-anchor="middle">' . $initials . '</text>';
    echo '</svg>';
    exit;
}

// Serve avatar
header('Content-Type: image/png');
header('Content-Length: ' . filesize($avatarPath));
header('Cache-Control: public, max-age=86400');
readfile($avatarPath);
