<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/csrf.php';
require_once __DIR__ . '/../../includes/PngHandler.php';

// Require login
Auth::requireLogin();

$success = '';
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verify CSRF
    CSRF::verifyOrDie();
    
    // Check if file uploaded
    if (!isset($_FILES['png_file']) || $_FILES['png_file']['error'] === UPLOAD_ERR_NO_FILE) {
        $errors[] = 'Pilih file PNG untuk diupload Master J';
    } else {
        $handler = new PngHandler();
        $result = $handler->process($_FILES['png_file']);
        
        if ($result) {
            $success = 'PNG berhasil diupload dengan transparansi tetap terjaga, Master J!';
        } else {
            $errors = $handler->getErrors();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeri Yesus V1 Created By Immortaldev</title>
    <meta name="robots" content="noindex">  
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://fonts.googleapis.com/css2?family=Questrial&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Questrial', sans-serif;
            background: #f5f5f5;
            color: #333;
        }
        .header {
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            font-size: 24px;
            color: #667eea;
        }
        .btn {
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            cursor: pointer;
            border: none;
            font-size: 14px;
            display: inline-block;
        }
        .btn-secondary {
            background: #f0f0f0;
            color: #666;
        }
        .btn-secondary:hover {
            background: #e0e0e0;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            padding: 0 30px;
        }
        .upload-card {
            background: white;
            border-radius: 12px;
            padding: 40px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .upload-card h2 {
            margin-bottom: 10px;
            color: #333;
        }
        .upload-card p {
            color: #666;
            margin-bottom: 30px;
        }
        .upload-area {
            border: 3px dashed #d0d0d0;
            border-radius: 12px;
            padding: 60px 30px;
            text-align: center;
            background: #fafafa;
            transition: all 0.3s;
            cursor: pointer;
            margin-bottom: 20px;
        }
        .upload-area:hover,
        .upload-area.dragover {
            border-color: #667eea;
            background: #f0f4ff;
        }
        .upload-icon {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.5;
        }
        .upload-area h3 {
            margin-bottom: 10px;
            color: #333;
        }
        .upload-area p {
            color: #999;
            margin: 0;
        }
        input[type="file"] {
            display: none;
        }
        .file-info {
            background: #f8f9fa;
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
        }
        .file-info.active {
            display: block;
        }
        .file-name {
            font-weight: 600;
            margin-bottom: 5px;
        }
        .file-size {
            color: #666;
            font-size: 14px;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            width: 100%;
            padding: 15px;
            font-size: 16px;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .btn-primary:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            transform: none;
        }
        .info-box {
            background: #f0f4ff;
            padding: 20px;
            border-radius: 8px;
            margin-top: 30px;
        }
        .info-box h4 {
            margin-bottom: 10px;
            color: #667eea;
        }
        .info-box ul {
            margin-left: 20px;
            color: #666;
        }
        .info-box li {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Form Upload Anak Tuhan V1.8.3</h1>
        <a href="<?php echo BASE_URL; ?>/index.php" class="btn btn-secondary">← Back to Gallery</a>
    </div>

    <div class="container">
        <div class="upload-card">
            <h2>Upload Png Disini Master J</h2>
            <p>Inget Master J Uploadnya backgroundnya ilangin dulu, Agar transparansi akan tetap terjaga</p>

            <form method="POST" enctype="multipart/form-data" id="upload-form">
                <?php echo CSRF::field(); ?>
                
                <div class="upload-area" id="upload-area" onclick="document.getElementById('png_file').click()">
                    <div class="upload-icon">🖼️</div>
                    <h3>Klik atau Drag & Drop PNG</h3>
                    <p>Hanya file PNG transparan (max <?php echo MAX_FILE_SIZE / 1024 / 1024; ?>MB)</p>
                </div>

                <input type="file" id="png_file" name="png_file" accept=".png,image/png" required>

                <div class="file-info" id="file-info">
                    <div class="file-name" id="file-name"></div>
                    <div class="file-size" id="file-size"></div>
                </div>

                <button type="submit" class="btn btn-primary" id="submit-btn" disabled>
                    Upload PNG
                </button>
            </form>

            <div class="info-box">
                <h4>Informasi Penting</h4>
                <ul>
                    <li><strong>Transparansi Terjaga:</strong> Alpha channel PNG akan dipertahankan 100%</li>
                    <li><strong>Kompresi Otomatis:</strong> File akan dikompresi (level <?php echo PNG_COMPRESSION; ?>) tanpa menghilangkan transparansi</li>
                    <li><strong>Thumbnail:</strong> Thumbnail <?php echo THUMBNAIL_SIZE; ?>px juga tetap transparan</li>
                    <li><strong>Format:</strong> Hanya PNG yang diterima, tidak ada konversi ke JPG</li>
                    <li><strong>Private:</strong> Semua file hanya bisa diakses oleh <strong>Master J</strong></li>
                </ul>
            </div>
        </div>
    </div>

    <script>
        const fileInput = document.getElementById('png_file');
        const uploadArea = document.getElementById('upload-area');
        const fileInfo = document.getElementById('file-info');
        const fileName = document.getElementById('file-name');
        const fileSize = document.getElementById('file-size');
        const submitBtn = document.getElementById('submit-btn');

        // File input change
        fileInput.addEventListener('change', function(e) {
            if (this.files.length > 0) {
                const file = this.files[0];
                showFileInfo(file);
            }
        });

        // Drag and drop
        uploadArea.addEventListener('dragover', function(e) {
            e.preventDefault();
            this.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', function(e) {
            e.preventDefault();
            this.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', function(e) {
            e.preventDefault();
            this.classList.remove('dragover');
            
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                fileInput.files = files;
                showFileInfo(files[0]);
            }
        });

        function showFileInfo(file) {
            fileName.textContent = '📄 ' + file.name;
            fileSize.textContent = 'Size: ' + formatFileSize(file.size);
            fileInfo.classList.add('active');
            submitBtn.disabled = false;

            // Validate PNG
            if (file.type !== 'image/png') {
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid File Type',
                    text: 'Cuma File PNG Saja Master J!',
                    confirmButtonColor: '#667eea'
                });
                resetForm();
            }
        }

        function formatFileSize(bytes) {
            if (bytes < 1024) return bytes + ' B';
            if (bytes < 1024 * 1024) return (bytes / 1024).toFixed(1) + ' KB';
            return (bytes / 1024 / 1024).toFixed(2) + ' MB';
        }

        function resetForm() {
            fileInput.value = '';
            fileInfo.classList.remove('active');
            submitBtn.disabled = true;
        }

        // Show success/error with SweetAlert
        <?php if ($success): ?>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: '<?php echo addslashes($success); ?>',
            confirmButtonColor: '#667eea',
            confirmButtonText: 'Kembali Ke Galeri Anda Master J'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = '<?php echo BASE_URL; ?>/index.php';
            }
        });
        <?php endif; ?>

        <?php if (!empty($errors)): ?>
        Swal.fire({
            icon: 'error',
            title: 'Upload Failed',
            html: '<?php echo implode("<br>", array_map('addslashes', $errors)); ?>',
            confirmButtonColor: '#667eea'
        });
        <?php endif; ?>

        // Form submit with loading
        document.getElementById('upload-form').addEventListener('submit', function(e) {
            if (!submitBtn.disabled) {
                Swal.fire({
                    title: 'Uploading...',
                    text: 'Tunggu Sebentar Master J, File Akan Segera Saya Upload!!',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
            }
        });
    </script>
</body>
</html>
