<?php
/**
 * Profile Avatar Server
 * Serves user profile avatar with authentication
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';

// Require login
Auth::requireLogin();

$avatarPath = STORAGE_PATH . '/avatar.png';

if (!file_exists($avatarPath)) {
    // Return default avatar SVG
    header('Content-Type: image/svg+xml');
    echo '<svg viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
        <defs>
            <linearGradient id="grad" x1="0%" y1="0%" x2="100%" y2="100%">
                <stop offset="0%" style="stop-color:#8B5CF6;stop-opacity:1" />
                <stop offset="100%" style="stop-color:#6D28D9;stop-opacity:1" />
            </linearGradient>
        </defs>
        <circle cx="100" cy="100" r="100" fill="url(#grad)"/>
        <circle cx="100" cy="75" r="30" fill="white" opacity="0.9"/>
        <path d="M 60 140 Q 100 110 140 140 L 140 200 L 60 200 Z" fill="white" opacity="0.9"/>
    </svg>';
    exit;
}

// Serve avatar
header('Content-Type: image/png');
header('Content-Length: ' . filesize($avatarPath));
header('Cache-Control: public, max-age=86400');
readfile($avatarPath);
