<?php
/**
 * Secure Image Server
 * 
 * File ini adalah SATU-SATUNYA cara untuk mengakses gambar.
 * Semua request gambar harus melalui file ini dengan session check.
 * 
 * Usage:
 * - Thumbnail: image.php?type=thumb&file=filename.png
 * - Optimized: image.php?type=optimized&file=filename.png
 * - Original: image.php?type=original&file=filename.png
 * - Download: image.php?type=original&file=filename.png&download=1
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/PngHandler.php';

// WAJIB LOGIN
Auth::requireLogin();

// Get parameters
$type = $_GET['type'] ?? 'optimized'; // thumb, optimized, original
$file = $_GET['file'] ?? '';
$download = isset($_GET['download']);

// Validate filename (prevent directory traversal)
$file = basename($file);
if (empty($file) || !preg_match('/^[a-zA-Z0-9_-]+\.png$/', $file)) {
    http_response_code(400);
    die('Invalid filename');
}

// Determine path based on type
switch ($type) {
    case 'thumb':
        $path = THUMBS_PATH . '/' . $file;
        break;
    case 'original':
        $path = ORIGINALS_PATH . '/' . $file;
        break;
    case 'optimized':
    default:
        $path = OPTIMIZED_PATH . '/' . $file;
        break;
}

// Check if file exists
if (!file_exists($path)) {
    http_response_code(404);
    die('File not found');
}

// Output PNG with transparency preserved
$handler = new PngHandler();
$handler->output($path, $download);
