# Private PNG Gallery System

Sistem galeri private untuk menyimpan PNG transparan dengan keamanan maksimal.

## Struktur Folder

```
png-gallery/
├── public/              # Web-accessible folder
│   ├── index.php       # Galeri utama
│   ├── login.php       # Halaman login
│   ├── logout.php      # Logout
│   ├── image.php       # Secure image server
│   ├── admin/          # Admin panel
│   │   ├── upload.php  # Upload gambar
│   │   └── delete.php  # Hapus gambar
│   └── assets/         # CSS/JS
│       └── style.css
├── storage/            # NON-PUBLIC (di luar public/)
│   ├── uploads/
│   │   ├── originals/  # PNG original
│   │   └── optimized/  # PNG terkompresi
│   └── thumbs/         # Thumbnail
├── includes/           # PHP includes
│   ├── config.php      # Konfigurasi
│   ├── auth.php        # Auth helper
│   ├── PngHandler.php  # PNG processor
│   └── csrf.php        # CSRF protection
└── .htaccess           # Protect storage folder
```

## Setup

1. **Konfigurasi Password**
   Edit `includes/config.php`:
   ```php
   // Ganti password default
   define('ADMIN_PASSWORD_HASH', password_hash('password_anda', PASSWORD_DEFAULT));
   ```

2. **Folder Permissions**
   ```bash
   chmod 755 public/
   chmod 700 storage/
   chmod 755 storage/uploads/originals/
   chmod 755 storage/uploads/optimized/
   chmod 755 storage/thumbs/
   ```

3. **Web Server**
   - Document root: `public/`
   - Storage folder HARUS di luar public/ atau dilindungi .htaccess

## Fitur Utama

✅ **Transparansi PNG Terjaga** - Alpha channel 0-255 tetap utuh
✅ **Kompresi PNG** - Compression level 6-9 (ukuran turun, transparan tetap)
✅ **Private Access** - Semua gambar hanya bisa diakses setelah login
✅ **Secure File Serving** - Tidak ada direct access ke file
✅ **CSRF Protection** - Form upload/delete terproteksi
✅ **File Validation** - Hanya PNG yang diizinkan
✅ **Thumbnail Transparan** - Thumbnail juga mempertahankan alpha

## Security Features

- Session-based authentication
- Password hashing dengan bcrypt
- CSRF token untuk semua form
- File type validation (MIME + extension)
- Semua file disimpan di non-public folder
- Direct access diblok dengan .htaccess

## Teknologi

- PHP 7.4+ (GD library)
- Session untuk autentikasi
- No database (file-based)
- Vanilla PHP (no framework)
