# 🖼️ PNG Gallery Private - Quick Start

## Sistem Galeri PNG Transparan

Sistem galeri private berbasis PHP native untuk menyimpan dan mengelola file PNG transparan dengan fokus **mempertahankan alpha channel** (transparansi) di seluruh proses.

## ✨ Fitur Utama

✅ **Transparansi 100% Terjaga** - Alpha channel PNG tetap utuh dari upload hingga download
✅ **Kompresi PNG** - Ukuran file turun 30-70% tanpa kehilangan transparansi  
✅ **Private & Secure** - Single user authentication, file tidak bisa diakses langsung
✅ **Simple UI** - Grid gallery dengan checkerboard background, lightbox, lazy load
✅ **CSRF Protected** - Semua form terproteksi
✅ **File Validation** - Hanya PNG yang diterima

## 🚀 Quick Start

### 1. Requirements

- PHP 7.4+ dengan GD extension
- Apache/Nginx web server
- 10MB+ disk space

### 2. Installation

```bash
# Extract files
unzip png-gallery.zip
cd png-gallery

# Run setup
php setup.php

# Set permissions (Linux)
chmod 755 public/
chmod 700 storage/
chmod 755 storage/uploads/originals/
chmod 755 storage/uploads/optimized/
chmod 755 storage/thumbs/
```

### 3. Configure Web Server

Point document root ke folder `public/`

**Apache VirtualHost:**
```apache
DocumentRoot /path/to/png-gallery/public
```

**Nginx:**
```nginx
root /path/to/png-gallery/public;
```

### 4. Change Password

Edit `includes/config.php`:

```bash
# Generate hash
php -r "echo password_hash('your_password', PASSWORD_DEFAULT);"

# Update config.php
define('ADMIN_PASSWORD_HASH', '$2y$10$..your_hash..');
```

### 5. Access

- URL: `http://your-domain/login.php`
- Username: `admin`
- Password: `password` (default, ganti di step 4)

## 📚 Documentation

- **README.md** - Overview lengkap
- **INSTALL.md** - Panduan instalasi detail (Apache/Nginx)
- **TESTING.md** - Cara test transparansi PNG
- **SUMMARY.md** - Technical summary & architecture

## 🔑 Key Files

```
png-gallery/
├── public/                  ← Point web server here
│   ├── index.php           ← Gallery
│   ├── login.php           ← Login page
│   ├── image.php           ← Secure image server
│   └── admin/
│       ├── upload.php      ← Upload PNG
│       └── delete.php      ← Delete PNG
├── includes/
│   ├── config.php          ← EDIT: Change password here
│   └── PngHandler.php      ← CRITICAL: PNG transparency logic
└── storage/                ← Private folder (TIDAK bisa diakses)
    ├── uploads/originals/  ← PNG original
    ├── uploads/optimized/  ← PNG compressed (transparent)
    └── thumbs/             ← Thumbnails (transparent)
```

## 🎯 Core Concept: Transparency Preservation

**CRITICAL CODE PATTERN:**

```php
// Load PNG
$img = imagecreatefrompng($source);

// WAJIB untuk transparansi:
imagealphablending($img, false);  // Disable blending
imagesavealpha($img, true);       // Enable save alpha

// Save with compression (0-9)
imagepng($img, $dest, 7);
imagedestroy($img);
```

Kode ini ada di `includes/PngHandler.php` dan digunakan untuk:
- Optimize PNG (kompresi)
- Create thumbnail
- Semua operasi PNG

## 🔒 Security Features

1. **Private Storage** - File di `storage/` tidak bisa diakses langsung
2. **Session Auth** - Semua akses harus login
3. **CSRF Protection** - Token untuk semua form
4. **File Validation** - MIME + extension check
5. **Password Hash** - Bcrypt untuk password

## 🧪 Test Transparency

1. Upload PNG transparan (bisa generate dengan `php demo_generate_png.php`)
2. Check thumbnail - harus ada checkerboard background
3. Click lightbox - transparency harus terlihat
4. Download - buka di Photoshop/GIMP, alpha channel harus ada

## ⚙️ Configuration

Edit `includes/config.php`:

```php
// Compression level (0-9, higher = smaller file)
define('PNG_COMPRESSION', 7);

// Thumbnail size (pixels)
define('THUMBNAIL_SIZE', 200);

// Max upload size (bytes)
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB

// Base URL (if in subdirectory)
define('BASE_URL', '/png-gallery/public');
```

## 🐛 Troubleshooting

**Issue: GD library not found**
```bash
# Ubuntu/Debian
sudo apt-get install php-gd
sudo systemctl restart apache2
```

**Issue: Permission denied**
```bash
sudo chown -R www-data:www-data storage/
chmod -R 755 storage/
```

**Issue: Transparency hilang**
- Check `PngHandler.php` lines 95-98 (imagealphablending + imagesavealpha)
- Pastikan GD extension installed: `php -m | grep gd`

**Issue: Cannot access images**
- ✅ INI BENAR! Storage folder tidak boleh diakses langsung
- Akses harus via `image.php` dengan login

## 📝 Notes

- **Folder `storage/` HARUS private** (sudah ada `.htaccess`)
- **Semua gambar diakses via `image.php`** (dengan session check)
- **Transparansi dijamin 100%** (alpha channel tetap utuh)
- **Single user system** (hanya admin yang bisa login)
- **No database** (file-based)

## 🎉 Done!

Upload PNG transparan Anda dan transparansi akan tetap terjaga!

**Default Login:**
- Username: `admin`  
- Password: `password` ⚠️ **GANTI SECEPATNYA!**

---

**Dokumentasi lengkap:** Baca `INSTALL.md` untuk setup detail

**Technical details:** Baca `SUMMARY.md` untuk architecture
